"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContentSwitcherPlayground = exports.Default = exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _addonKnobs = require("@storybook/addon-knobs");

var _ContentSwitcher = _interopRequireDefault(require("../ContentSwitcher"));

var _Switch = _interopRequireDefault(require("../Switch"));

var _ContentSwitcher2 = _interopRequireDefault(require("./ContentSwitcher.mdx"));

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var selectionModes = {
  'Change selection automatically upon focus (automatic)': 'automatic',
  'Change selection on explicit gesture (manual)': 'manual'
};
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var props = {
  contentSwitcher: function contentSwitcher() {
    return {
      light: (0, _addonKnobs.boolean)('[Deprecated]: Light variant (light)', false),
      selectedIndex: (0, _addonKnobs.select)('Selected index (selectedIndex)', [0, 1, 2], 0),
      selectionMode: (0, _addonKnobs.select)('Selection mode (selectionMode)', selectionModes, 'automatic'),
      size: (0, _addonKnobs.select)('Field size (size)', sizes, undefined) || undefined,
      onChange: (0, _addonActions.action)('onChange')
    };
  },
  switch: function _switch() {
    return {
      onClick: (0, _addonActions.action)('onClick - Switch'),
      disabled: (0, _addonKnobs.boolean)('Disabled (disabled)', false)
    };
  }
};
var _default = {
  title: 'Components/ContentSwitcher',
  decorators: [_addonKnobs.withKnobs],
  parameters: {
    component: _ContentSwitcher.default,
    subcomponents: {
      Switch: _Switch.default
    },
    docs: {
      page: _ContentSwitcher2.default
    }
  }
};
exports.default = _default;

var Default = function Default() {
  return /*#__PURE__*/_react.default.createElement(_ContentSwitcher.default, {
    onChange: function onChange() {}
  }, /*#__PURE__*/_react.default.createElement(_Switch.default, {
    name: "one",
    text: "First section"
  }), /*#__PURE__*/_react.default.createElement(_Switch.default, {
    name: "two",
    text: "Second section"
  }), /*#__PURE__*/_react.default.createElement(_Switch.default, {
    name: "three",
    text: "Third section"
  }));
};

exports.Default = Default;
Default.story = {
  name: 'Content Switcher'
};

var ContentSwitcherPlayground = function ContentSwitcherPlayground() {
  var switchProps = props.switch();
  return /*#__PURE__*/_react.default.createElement(_ContentSwitcher.default, props.contentSwitcher(), /*#__PURE__*/_react.default.createElement(_Switch.default, (0, _extends2.default)({
    name: "one",
    text: "First section"
  }, switchProps)), /*#__PURE__*/_react.default.createElement(_Switch.default, (0, _extends2.default)({
    name: "two",
    text: "Second section"
  }, switchProps)), /*#__PURE__*/_react.default.createElement(_Switch.default, (0, _extends2.default)({
    name: "three",
    text: "Third section"
  }, switchProps)));
};

exports.ContentSwitcherPlayground = ContentSwitcherPlayground;