"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _react = _interopRequireDefault(require("react"));

var _enzyme = require("enzyme");

var _Button = _interopRequireDefault(require("../../Button"));

var _ModalFooter = require("./ModalFooter");

var _InlineLoading = _interopRequireDefault(require("../../InlineLoading"));

var _carbonComponents = require("carbon-components");

var prefix = _carbonComponents.settings.prefix;
describe('<ModalFooter />', function () {
  describe('Renders as expected', function () {
    var wrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ModalFooter.ModalFooter, {
      className: "extra-class"
    }, /*#__PURE__*/_react.default.createElement("p", null, "Test")));
    it('renders children as expected', function () {
      expect(wrapper.find('p').length).toBe(1);
    });
    it('renders wrapper as expected', function () {
      expect(wrapper.length).toBe(1);
    });
    it('renders extra classes passed in via className', function () {
      expect(wrapper.hasClass('extra-class')).toEqual(true);
    });
  });
  describe('Should render buttons only if appropriate prop passed in', function () {
    var wrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_ModalFooter.ModalFooter, {
      className: "extra-class"
    }, /*#__PURE__*/_react.default.createElement("p", null, "Test")));
    var primaryWrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_ModalFooter.ModalFooter, {
      primaryButtonText: "test"
    }));
    var secondaryWrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ModalFooter.ModalFooter, {
      secondaryButtonText: "test"
    }));
    var multipleSecondaryWrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ModalFooter.ModalFooter, {
      secondaryButtons: [{
        buttonText: /*#__PURE__*/_react.default.createElement(_InlineLoading.default, null),
        onClick: jest.fn()
      }, {
        buttonText: 'Cancel',
        onClick: jest.fn()
      }]
    }));
    it('does not render primary button if no primary text', function () {
      expect(wrapper.find(".".concat(prefix, "--btn--primary")).exists()).toBe(false);
    });
    it('does not render secondary button if no secondary text', function () {
      expect(wrapper.find(".".concat(prefix, "--btn--secondary")).exists()).toBe(false);
    });
    it('renders primary button if primary text', function () {
      var buttonComponent = primaryWrapper.find(_Button.default);
      expect(buttonComponent.exists()).toBe(true);
      expect(buttonComponent.props().kind).toBe('primary');
    });
    it('renders primary button if secondary text', function () {
      var buttonComponent = secondaryWrapper.find(_Button.default);
      expect(buttonComponent.exists()).toBe(true);
      expect(buttonComponent.props().kind).toBe('secondary');
    });
    it('correctly renders multiple secondary buttons', function () {
      var buttonComponents = multipleSecondaryWrapper.find(_Button.default);
      expect(buttonComponents.length).toEqual(2);
      expect(buttonComponents.at(0).props().kind).toBe('secondary');
      expect(buttonComponents.at(1).props().kind).toBe('secondary');
    });
  });
  describe('Should render the appropriate buttons when `danger` prop is true', function () {
    var primaryWrapper = (0, _enzyme.shallow)( /*#__PURE__*/_react.default.createElement(_ModalFooter.ModalFooter, {
      primaryButtonText: "test",
      danger: true
    }));
    var secondaryWrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ModalFooter.ModalFooter, {
      secondaryButtonText: "test",
      danger: true
    }));
    var multipleSecondaryWrapper = (0, _enzyme.mount)( /*#__PURE__*/_react.default.createElement(_ModalFooter.ModalFooter, {
      secondaryButtons: [{
        buttonText: /*#__PURE__*/_react.default.createElement(_InlineLoading.default, null),
        onClick: jest.fn()
      }, {
        buttonText: 'Cancel',
        onClick: jest.fn()
      }]
    }));
    it('renders danger button if primary text && danger', function () {
      var buttonComponent = primaryWrapper.find(_Button.default);
      expect(buttonComponent.exists()).toBe(true);
      expect(buttonComponent.props().kind).toBe('danger');
    });
    it('renders secondary button if secondary text && danger', function () {
      var buttonComponent = secondaryWrapper.find(_Button.default);
      expect(buttonComponent.exists()).toBe(true);
      expect(buttonComponent.prop('kind')).toBe('secondary');
    });
    it('correctly renders multiple secondary buttons', function () {
      var buttonComponents = multipleSecondaryWrapper.find(_Button.default);
      expect(buttonComponents.length).toEqual(2);
      expect(buttonComponents.at(0).props().kind).toBe('secondary');
      expect(buttonComponents.at(1).props().kind).toBe('secondary');
    });
  });
});