"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.skeleton = exports.singlelineWithLayer = exports.multilineWithLayer = exports.inlineWithLayer = exports.singleline = exports.multiline = exports.inline = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _ = _interopRequireWildcard(require("../"));

var _Layer = require("../../Layer");

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Components/CodeSnippet',
  component: _.default
};
exports.default = _default;

var inline = function inline() {
  return /*#__PURE__*/_react.default.createElement(_.default, {
    type: "inline",
    feedback: "Copied to clipboard"
  }, 'node -v');
};

exports.inline = inline;

var multiline = function multiline() {
  return /*#__PURE__*/_react.default.createElement(_.default, {
    type: "multi",
    feedback: "Copied to clipboard"
  }, "  \"scripts\": {\n    \"build\": \"lerna run build --stream --prefix --npm-client yarn\",\n    \"ci-check\": \"carbon-cli ci-check\",\n    \"clean\": \"lerna run clean && lerna clean --yes && rimraf node_modules\",\n    \"doctoc\": \"doctoc --title '## Table of Contents'\",\n    \"format\": \"prettier --write '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**'\",\n    \"format:diff\": \"prettier --list-different '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**' '!packages/components/**'\",\n    \"lint\": \"eslint actions config codemods packages\",\n    \"lint:styles\": \"stylelint '**/*.{css,scss}' --report-needless-disables --report-invalid-scope-disables\",\n    \"sync\": \"carbon-cli sync\",\n    \"test\": \"cross-env BABEL_ENV=test jest\",\n    \"test:e2e\": \"cross-env BABEL_ENV=test jest --testPathPattern=e2e --testPathIgnorePatterns='examples,/packages/components/,/packages/react/'\"\n  },\n  \"resolutions\": {\n    \"react\": \"~16.9.0\",\n    \"react-dom\": \"~16.9.0\",\n    \"react-is\": \"~16.9.0\",\n    \"react-test-renderer\": \"~16.9.0\"\n  },\n  \"devDependencies\": {\n    \"@babel/core\": \"^7.10.0\",\n    \"@babel/plugin-proposal-class-properties\": \"^7.7.4\",\n    \"@babel/plugin-proposal-export-default-from\": \"^7.7.4\",\n    \"@babel/plugin-proposal-export-namespace-from\": \"^7.7.4\",\n    \"@babel/plugin-transform-runtime\": \"^7.10.0\",\n    \"@babel/preset-env\": \"^7.10.0\",\n    \"@babel/preset-react\": \"^7.10.0\",\n    \"@babel/runtime\": \"^7.10.0\",\n    \"@commitlint/cli\": \"^8.3.5\",");
};

exports.multiline = multiline;

var singleline = function singleline() {
  return /*#__PURE__*/_react.default.createElement(_.default, {
    type: "single",
    feedback: "Copied to clipboard"
  }, "yarn add carbon-components@latest carbon-components-react@latest @carbon/icons-react@latest carbon-icons@latest");
};

exports.singleline = singleline;

var inlineWithLayer = function inlineWithLayer() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.default, {
    type: "inline",
    feedback: "Copied to clipboard"
  }, 'node -v'), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    type: "inline",
    feedback: "Copied to clipboard"
  }, 'node -v'), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    type: "inline",
    feedback: "Copied to clipboard"
  }, 'node -v'))));
};

exports.inlineWithLayer = inlineWithLayer;

var multilineWithLayer = function multilineWithLayer() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.default, {
    type: "multi",
    feedback: "Copied to clipboard"
  }, "  \"scripts\": {\n        \"build\": \"lerna run build --stream --prefix --npm-client yarn\",\n        \"ci-check\": \"carbon-cli ci-check\",\n        \"clean\": \"lerna run clean && lerna clean --yes && rimraf node_modules\",\n        \"doctoc\": \"doctoc --title '## Table of Contents'\",\n        \"format\": \"prettier --write '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**'\",\n        \"format:diff\": \"prettier --list-different '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**' '!packages/components/**'\",\n        \"lint\": \"eslint actions config codemods packages\",\n        \"lint:styles\": \"stylelint '**/*.{css,scss}' --report-needless-disables --report-invalid-scope-disables\",\n        \"sync\": \"carbon-cli sync\",\n        \"test\": \"cross-env BABEL_ENV=test jest\",\n        \"test:e2e\": \"cross-env BABEL_ENV=test jest --testPathPattern=e2e --testPathIgnorePatterns='examples,/packages/components/,/packages/react/'\"\n        },\n        \"resolutions\": {\n          \"react\": \"~16.9.0\",\n          \"react-dom\": \"~16.9.0\",\n          \"react-is\": \"~16.9.0\",\n          \"react-test-renderer\": \"~16.9.0\"\n        },\n        \"devDependencies\": {\n          \"@babel/core\": \"^7.10.0\",\n          \"@babel/plugin-proposal-class-properties\": \"^7.7.4\",\n          \"@babel/plugin-proposal-export-default-from\": \"^7.7.4\",\n          \"@babel/plugin-proposal-export-namespace-from\": \"^7.7.4\",\n          \"@babel/plugin-transform-runtime\": \"^7.10.0\",\n          \"@babel/preset-env\": \"^7.10.0\",\n          \"@babel/preset-react\": \"^7.10.0\",\n          \"@babel/runtime\": \"^7.10.0\",\n          \"@commitlint/cli\": \"^8.3.5\","), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    type: "multi",
    feedback: "Copied to clipboard"
  }, "  \"scripts\": {\n          \"build\": \"lerna run build --stream --prefix --npm-client yarn\",\n          \"ci-check\": \"carbon-cli ci-check\",\n          \"clean\": \"lerna run clean && lerna clean --yes && rimraf node_modules\",\n          \"doctoc\": \"doctoc --title '## Table of Contents'\",\n          \"format\": \"prettier --write '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**'\",\n          \"format:diff\": \"prettier --list-different '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**' '!packages/components/**'\",\n          \"lint\": \"eslint actions config codemods packages\",\n          \"lint:styles\": \"stylelint '**/*.{css,scss}' --report-needless-disables --report-invalid-scope-disables\",\n          \"sync\": \"carbon-cli sync\",\n          \"test\": \"cross-env BABEL_ENV=test jest\",\n          \"test:e2e\": \"cross-env BABEL_ENV=test jest --testPathPattern=e2e --testPathIgnorePatterns='examples,/packages/components/,/packages/react/'\"\n          },\n          \"resolutions\": {\n            \"react\": \"~16.9.0\",\n            \"react-dom\": \"~16.9.0\",\n            \"react-is\": \"~16.9.0\",\n            \"react-test-renderer\": \"~16.9.0\"\n          },\n          \"devDependencies\": {\n            \"@babel/core\": \"^7.10.0\",\n            \"@babel/plugin-proposal-class-properties\": \"^7.7.4\",\n            \"@babel/plugin-proposal-export-default-from\": \"^7.7.4\",\n            \"@babel/plugin-proposal-export-namespace-from\": \"^7.7.4\",\n            \"@babel/plugin-transform-runtime\": \"^7.10.0\",\n            \"@babel/preset-env\": \"^7.10.0\",\n            \"@babel/preset-react\": \"^7.10.0\",\n            \"@babel/runtime\": \"^7.10.0\",\n            \"@commitlint/cli\": \"^8.3.5\","), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    type: "multi",
    feedback: "Copied to clipboard"
  }, "  \"scripts\": {\n            \"build\": \"lerna run build --stream --prefix --npm-client yarn\",\n            \"ci-check\": \"carbon-cli ci-check\",\n            \"clean\": \"lerna run clean && lerna clean --yes && rimraf node_modules\",\n            \"doctoc\": \"doctoc --title '## Table of Contents'\",\n            \"format\": \"prettier --write '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**'\",\n            \"format:diff\": \"prettier --list-different '**/*.{js,md,scss,ts}' '!**/{build,es,lib,storybook,ts,umd}/**' '!packages/components/**'\",\n            \"lint\": \"eslint actions config codemods packages\",\n            \"lint:styles\": \"stylelint '**/*.{css,scss}' --report-needless-disables --report-invalid-scope-disables\",\n            \"sync\": \"carbon-cli sync\",\n            \"test\": \"cross-env BABEL_ENV=test jest\",\n            \"test:e2e\": \"cross-env BABEL_ENV=test jest --testPathPattern=e2e --testPathIgnorePatterns='examples,/packages/components/,/packages/react/'\"\n            },\n            \"resolutions\": {\n              \"react\": \"~16.9.0\",\n              \"react-dom\": \"~16.9.0\",\n              \"react-is\": \"~16.9.0\",\n              \"react-test-renderer\": \"~16.9.0\"\n            },\n            \"devDependencies\": {\n              \"@babel/core\": \"^7.10.0\",\n              \"@babel/plugin-proposal-class-properties\": \"^7.7.4\",\n              \"@babel/plugin-proposal-export-default-from\": \"^7.7.4\",\n              \"@babel/plugin-proposal-export-namespace-from\": \"^7.7.4\",\n              \"@babel/plugin-transform-runtime\": \"^7.10.0\",\n              \"@babel/preset-env\": \"^7.10.0\",\n              \"@babel/preset-react\": \"^7.10.0\",\n              \"@babel/runtime\": \"^7.10.0\",\n              \"@commitlint/cli\": \"^8.3.5\","))));
};

exports.multilineWithLayer = multilineWithLayer;

var singlelineWithLayer = function singlelineWithLayer() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.default, {
    type: "single",
    feedback: "Copied to clipboard"
  }, "yarn add carbon-components@latest carbon-components-react@latest @carbon/icons-react@latest carbon-icons@latest"), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    type: "single",
    feedback: "Copied to clipboard"
  }, "yarn add carbon-components@latest carbon-components-react@latest @carbon/icons-react@latest carbon-icons@latest"), /*#__PURE__*/_react.default.createElement(_Layer.Layer, null, /*#__PURE__*/_react.default.createElement(_.default, {
    type: "single",
    feedback: "Copied to clipboard"
  }, "yarn add carbon-components@latest carbon-components-react@latest @carbon/icons-react@latest carbon-icons@latest"))));
};

exports.singlelineWithLayer = singlelineWithLayer;

var skeleton = function skeleton() {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_.CodeSnippetSkeleton, {
    type: "single",
    style: {
      marginBottom: 8
    }
  }), /*#__PURE__*/_react.default.createElement(_.CodeSnippetSkeleton, {
    type: "multi"
  }));
};

exports.skeleton = skeleton;