"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _react = _interopRequireDefault(require("react"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _excluded = ["children", "className", "stacked"];
var prefix = _carbonComponents.settings.prefix;

var ButtonSet = /*#__PURE__*/_react.default.forwardRef(function ButtonSet(_ref, ref) {
  var children = _ref.children,
      className = _ref.className,
      stacked = _ref.stacked,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var buttonSetClasses = (0, _classnames.default)(className, "".concat(prefix, "--btn-set"), (0, _defineProperty2.default)({}, "".concat(prefix, "--btn-set--stacked"), stacked));
  return /*#__PURE__*/_react.default.createElement("div", (0, _extends2.default)({}, rest, {
    className: buttonSetClasses,
    ref: ref
  }), children);
});

ButtonSet.displayName = 'ButtonSet';
ButtonSet.propTypes = {
  /**
   * Specify the content of your ButtonSet
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be added to your ButtonSet
   */
  className: _propTypes.default.string,

  /**
   * Specify the button arrangement of the set (vertically stacked or
   * horizontal)
   */
  stacked: _propTypes.default.bool
};
var _default = ButtonSet;
exports.default = _default;