"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

var _typeof = require("@babel/runtime/helpers/typeof");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Skeleton = exports.SetOfButtons = exports.IconButton = exports.Ghost = exports.Danger = exports.Tertiary = exports.Secondary = exports._Default = exports.default = void 0;

var _react = _interopRequireDefault(require("react"));

var _addonActions = require("@storybook/addon-actions");

var _iconsReact = require("@carbon/icons-react");

var _ = _interopRequireWildcard(require("../"));

var _ButtonSet = _interopRequireDefault(require("../../ButtonSet"));

function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }

function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
var _default = {
  title: 'Components/Button',
  parameters: {
    component: _.default,
    subcomponents: {
      ButtonSet: _ButtonSet.default,
      ButtonSkeleton: _.ButtonSkeleton
    }
  }
};
exports.default = _default;

var _Default = function _Default() {
  return /*#__PURE__*/_react.default.createElement(_.default, null, "Button");
};

exports._Default = _Default;

var Secondary = function Secondary() {
  return /*#__PURE__*/_react.default.createElement(_.default, {
    kind: "secondary"
  }, "Button");
};

exports.Secondary = Secondary;

var Tertiary = function Tertiary() {
  return /*#__PURE__*/_react.default.createElement(_.default, {
    kind: "tertiary"
  }, "Button");
};

exports.Tertiary = Tertiary;

var Danger = function Danger() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_.default, {
    kind: "danger"
  }, "Button"), "\xA0", /*#__PURE__*/_react.default.createElement(_.default, {
    kind: "danger--tertiary"
  }, "Tertiary Danger Button"), "\xA0", /*#__PURE__*/_react.default.createElement(_.default, {
    kind: "danger--ghost"
  }, "Ghost Danger Button"));
};

exports.Danger = Danger;

var Ghost = function Ghost() {
  return /*#__PURE__*/_react.default.createElement(_.default, {
    kind: "ghost"
  }, "Button");
};

exports.Ghost = Ghost;

var IconButton = function IconButton() {
  return /*#__PURE__*/_react.default.createElement(_.default, {
    renderIcon: _iconsReact.Add16,
    iconDescription: "Icon Description",
    hasIconOnly: true,
    onClick: (0, _addonActions.action)('onClick')
  });
};

exports.IconButton = IconButton;

var SetOfButtons = function SetOfButtons() {
  return /*#__PURE__*/_react.default.createElement(_ButtonSet.default, null, /*#__PURE__*/_react.default.createElement(_.default, {
    kind: "secondary"
  }, "Secondary button"), /*#__PURE__*/_react.default.createElement(_.default, {
    kind: "primary"
  }, "Primary button"));
};

exports.SetOfButtons = SetOfButtons;

var Skeleton = function Skeleton() {
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_.ButtonSkeleton, null), "\xA0", /*#__PURE__*/_react.default.createElement(_.ButtonSkeleton, {
    small: true
  }));
};

exports.Skeleton = Skeleton;