"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _carbonComponents = require("carbon-components");

var _Link = _interopRequireDefault(require("../Link"));

var _iconsReact = require("@carbon/icons-react");

var _excluded = ["aria-current", "children", "className", "href", "isCurrentPage"];
var prefix = _carbonComponents.settings.prefix;

var BreadcrumbItem = /*#__PURE__*/_react.default.forwardRef(function BreadcrumbItem(_ref, ref) {
  var _cx;

  var ariaCurrent = _ref['aria-current'],
      children = _ref.children,
      customClassName = _ref.className,
      href = _ref.href,
      isCurrentPage = _ref.isCurrentPage,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var className = (0, _classnames.default)((_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--breadcrumb-item"), true), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--breadcrumb-item--current"), isCurrentPage && ariaCurrent !== 'page'), (0, _defineProperty2.default)(_cx, customClassName, !!customClassName), _cx));

  if (children.type && children.type.displayName !== undefined && children.type.displayName.includes('OverflowMenu')) {
    var horizontalOverflowIcon = /*#__PURE__*/_react.default.createElement(_iconsReact.OverflowMenuHorizontal16, {
      className: "".concat(prefix, "--overflow-menu__icon")
    });

    return /*#__PURE__*/_react.default.createElement("li", (0, _extends2.default)({
      className: className
    }, rest), /*#__PURE__*/_react.default.cloneElement(children, {
      menuOptionsClass: "".concat(prefix, "--breadcrumb-menu-options"),
      menuOffset: {
        top: 10,
        left: 59
      },
      renderIcon: function renderIcon() {
        return horizontalOverflowIcon;
      }
    }));
  }

  if (typeof children === 'string') {
    return /*#__PURE__*/_react.default.createElement("li", (0, _extends2.default)({
      className: className,
      ref: ref
    }, rest), href ? /*#__PURE__*/_react.default.createElement(_Link.default, {
      href: href,
      "aria-current": ariaCurrent
    }, children) : /*#__PURE__*/_react.default.createElement("span", {
      className: "".concat(prefix, "--link")
    }, children));
  }

  return /*#__PURE__*/_react.default.createElement("li", (0, _extends2.default)({
    className: className,
    ref: ref
  }, rest), /*#__PURE__*/_react.default.cloneElement(children, {
    'aria-current': ariaCurrent,
    className: (0, _classnames.default)("".concat(prefix, "--link"), children.props.className)
  }));
});

BreadcrumbItem.displayName = 'BreadcrumbItem';
BreadcrumbItem.propTypes = {
  'aria-current': _propTypes.default.oneOfType([_propTypes.default.string, _propTypes.default.bool]),

  /**
   * Pass in content that will be inside of the BreadcrumbItem
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Optional string representing the link location for the BreadcrumbItem
   */
  href: _propTypes.default.string,

  /**
   * Provide if this breadcrumb item represents the current page
   */
  isCurrentPage: _propTypes.default.bool
};
var _default = BreadcrumbItem;
exports.default = _default;