"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _classnames = _interopRequireDefault(require("classnames"));

var _usePrefix = require("../../internal/usePrefix");

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _excluded = ["align", "children", "className", "disabled", "size"];

function Accordion(_ref) {
  var _cx;

  var align = _ref.align,
      children = _ref.children,
      customClassName = _ref.className,
      disabled = _ref.disabled,
      size = _ref.size,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var className = (0, _classnames.default)("".concat(prefix, "--accordion"), customClassName, (_cx = {}, (0, _defineProperty2.default)(_cx, "".concat(prefix, "--accordion--").concat(align), align), (0, _defineProperty2.default)(_cx, "".concat(prefix, "--accordion--").concat(size), size), _cx));
  return /*#__PURE__*/_react.default.createElement("ul", (0, _extends2.default)({
    className: className
  }, rest), disabled ? _react.default.Children.toArray(children).map(function (child) {
    return /*#__PURE__*/_react.default.cloneElement(child, {
      disabled: disabled
    });
  }) : children);
}

Accordion.defaultProps = {
  align: 'end'
};
Accordion.propTypes = {
  /**
   * Specify the alignment of the accordion heading title and chevron.
   */
  align: _propTypes.default.oneOf(['start', 'end']),

  /**
   * Pass in the children that will be rendered within the Accordion
   */
  children: _propTypes.default.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: _propTypes.default.string,

  /**
   * Specify whether an individual AccordionItem should be disabled
   */
  disabled: _propTypes.default.bool,

  /**
   * Specify the size of the Accordion. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   * TODO V11: remove `xl` (replaced with lg)
   */
  size: _propTypes.default.oneOf(['sm', 'md', 'lg', 'xl'])
};
var _default = Accordion;
exports.default = _default;