"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;

var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));

var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));

var _objectWithoutProperties2 = _interopRequireDefault(require("@babel/runtime/helpers/objectWithoutProperties"));

var _propTypes = _interopRequireDefault(require("prop-types"));

var _react = _interopRequireDefault(require("react"));

var _classnames = _interopRequireDefault(require("classnames"));

var _iconsReact = require("@carbon/icons-react");

var _SkeletonText = _interopRequireDefault(require("../SkeletonText"));

var _deprecate = _interopRequireDefault(require("../../prop-types/deprecate"));

var _usePrefix = require("../../internal/usePrefix");

var _excluded = ["align", "open", "count", "className"];

function AccordionSkeleton(_ref) {
  var align = _ref.align,
      open = _ref.open,
      count = _ref.count,
      className = _ref.className,
      rest = (0, _objectWithoutProperties2.default)(_ref, _excluded);
  var prefix = (0, _usePrefix.usePrefix)();
  var classes = (0, _classnames.default)("".concat(prefix, "--accordion"), "".concat(prefix, "--skeleton"), className, (0, _defineProperty2.default)({}, "".concat(prefix, "--accordion--").concat(align), align));
  var numSkeletonItems = open ? count - 1 : count;
  return /*#__PURE__*/_react.default.createElement("ul", (0, _extends2.default)({
    className: classes
  }, rest), open && /*#__PURE__*/_react.default.createElement("li", {
    className: "".concat(prefix, "--accordion__item ").concat(prefix, "--accordion__item--active")
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--accordion__heading")
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.ChevronRight16, {
    className: "".concat(prefix, "--accordion__arrow")
  }), /*#__PURE__*/_react.default.createElement(_SkeletonText.default, {
    className: "".concat(prefix, "--accordion__title")
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "".concat(prefix, "--accordion__content")
  }, /*#__PURE__*/_react.default.createElement(_SkeletonText.default, {
    width: "90%"
  }), /*#__PURE__*/_react.default.createElement(_SkeletonText.default, {
    width: "80%"
  }), /*#__PURE__*/_react.default.createElement(_SkeletonText.default, {
    width: "95%"
  }))), Array.from({
    length: numSkeletonItems
  }).map(function (_, i) {
    return /*#__PURE__*/_react.default.createElement(AccordionSkeletonItem, {
      key: i
    });
  }));
}

AccordionSkeleton.propTypes = {
  /**
   * Specify the alignment of the accordion heading title and chevron.
   */
  align: _propTypes.default.oneOf(['start', 'end']),

  /**
   * Specify an optional className to add.
   */
  className: _propTypes.default.string,

  /**
   * Set number of items to render
   */
  count: _propTypes.default.number,

  /**
   * `false` to not display the first item opened
   */
  open: _propTypes.default.bool,

  /**
   * Set unique identifier to generate unique item keys
   */
  uid: (0, _deprecate.default)(_propTypes.default.any)
};
AccordionSkeleton.defaultProps = {
  open: true,
  count: 4,
  align: 'end'
};

function AccordionSkeletonItem() {
  var prefix = (0, _usePrefix.usePrefix)();
  return /*#__PURE__*/_react.default.createElement("li", {
    className: "".concat(prefix, "--accordion__item")
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "".concat(prefix, "--accordion__heading")
  }, /*#__PURE__*/_react.default.createElement(_iconsReact.ChevronRight16, {
    className: "".concat(prefix, "--accordion__arrow")
  }), /*#__PURE__*/_react.default.createElement(_SkeletonText.default, {
    className: "".concat(prefix, "--accordion__title")
  })));
}

var _default = AccordionSkeleton;
exports.default = _default;