import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useCallback, useEffect, useState, useRef } from 'react';
import PropTypes from 'prop-types';
import isEqual from 'lodash.isequal';

function callOnChangeHandler(_ref) {
  var isControlled = _ref.isControlled,
      isMounted = _ref.isMounted,
      onChangeHandlerControlled = _ref.onChangeHandlerControlled,
      onChangeHandlerUncontrolled = _ref.onChangeHandlerUncontrolled,
      selectedItems = _ref.selectedItems;

  if (isControlled) {
    if (isMounted && onChangeHandlerControlled) {
      onChangeHandlerControlled({
        selectedItems: selectedItems
      });
    }
  } else {
    onChangeHandlerUncontrolled(selectedItems);
  }
}

export function useSelection(_ref2) {
  var disabled = _ref2.disabled,
      onChange = _ref2.onChange,
      _ref2$initialSelected = _ref2.initialSelectedItems,
      initialSelectedItems = _ref2$initialSelected === void 0 ? [] : _ref2$initialSelected,
      controlledItems = _ref2.selectedItems;
  var isMounted = useRef(false);
  var savedOnChange = useRef(onChange);

  var _useState = useState(initialSelectedItems),
      _useState2 = _slicedToArray(_useState, 2),
      uncontrolledItems = _useState2[0],
      setUncontrolledItems = _useState2[1];

  var isControlled = !!controlledItems;
  var selectedItems = isControlled ? controlledItems : uncontrolledItems;
  var onItemChange = useCallback(function (item) {
    if (disabled) {
      return;
    }

    var selectedIndex;
    selectedItems.forEach(function (selectedItem, index) {
      if (isEqual(selectedItem, item)) {
        selectedIndex = index;
      }
    });
    var newSelectedItems;

    if (selectedIndex === undefined) {
      newSelectedItems = selectedItems.concat(item);
      callOnChangeHandler({
        isControlled: isControlled,
        isMounted: isMounted.current,
        onChangeHandlerControlled: savedOnChange.current,
        onChangeHandlerUncontrolled: setUncontrolledItems,
        selectedItems: newSelectedItems
      });
      return;
    }

    newSelectedItems = removeAtIndex(selectedItems, selectedIndex);
    callOnChangeHandler({
      isControlled: isControlled,
      isMounted: isMounted.current,
      onChangeHandlerControlled: savedOnChange.current,
      onChangeHandlerUncontrolled: setUncontrolledItems,
      selectedItems: newSelectedItems
    });
  }, [disabled, isControlled, selectedItems]);
  var clearSelection = useCallback(function () {
    if (disabled) {
      return;
    }

    callOnChangeHandler({
      isControlled: isControlled,
      isMounted: isMounted.current,
      onChangeHandlerControlled: savedOnChange.current,
      onChangeHandlerUncontrolled: setUncontrolledItems,
      selectedItems: []
    });
  }, [disabled, isControlled]);
  useEffect(function () {
    savedOnChange.current = onChange;
  }, [onChange]);
  useEffect(function () {
    if (isMounted.current && savedOnChange.current && !isControlled) {
      savedOnChange.current({
        selectedItems: selectedItems
      });
    }
  }, [isControlled, selectedItems]);
  useEffect(function () {
    isMounted.current = true;
    return function () {
      isMounted.current = false;
    };
  }, []);
  return {
    selectedItems: selectedItems,
    onItemChange: onItemChange,
    clearSelection: clearSelection
  };
}

var Selection = /*#__PURE__*/function (_React$Component) {
  _inherits(Selection, _React$Component);

  var _super = _createSuper(Selection);

  function Selection(props) {
    var _this;

    _classCallCheck(this, Selection);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "internalSetState", function (stateToSet, callback) {
      return _this.setState(stateToSet, function () {
        if (callback) {
          callback();
        }

        if (_this.props.onChange) {
          _this.props.onChange(_this.state);
        }
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleClearSelection", function () {
      if (_this.props.disabled) {
        return;
      }

      _this.internalSetState({
        selectedItems: []
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleSelectItem", function (item) {
      _this.internalSetState(function (state) {
        return {
          selectedItems: state.selectedItems.concat(item)
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleRemoveItem", function (index) {
      _this.internalSetState(function (state) {
        return {
          selectedItems: removeAtIndex(state.selectedItems, index)
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleOnItemChange", function (item) {
      if (_this.props.disabled) {
        return;
      }

      var selectedItems = _this.state.selectedItems;
      var selectedIndex;
      selectedItems.forEach(function (selectedItem, index) {
        if (isEqual(selectedItem, item)) {
          selectedIndex = index;
        }
      });

      if (selectedIndex === undefined) {
        _this.handleSelectItem(item);

        return;
      }

      _this.handleRemoveItem(selectedIndex);
    });

    _this.state = {
      selectedItems: props.initialSelectedItems
    };
    return _this;
  }

  _createClass(Selection, [{
    key: "render",
    value: function render() {
      var _this$props = this.props,
          children = _this$props.children,
          render = _this$props.render;
      var selectedItems = this.state.selectedItems;
      var renderProps = {
        selectedItems: selectedItems,
        onItemChange: this.handleOnItemChange,
        clearSelection: this.handleClearSelection
      };

      if (render !== undefined) {
        return render(renderProps);
      }

      if (children !== undefined) {
        return children(renderProps);
      }

      return null;
    }
  }]);

  return Selection;
}(React.Component); // Generic utility for safely removing an element at a given index from an
// array.


_defineProperty(Selection, "propTypes", {
  children: PropTypes.func,
  disabled: PropTypes.bool,
  initialSelectedItems: PropTypes.array.isRequired,
  onChange: PropTypes.func,
  render: PropTypes.func
});

_defineProperty(Selection, "defaultProps", {
  initialSelectedItems: []
});

export { Selection as default };

var removeAtIndex = function removeAtIndex(array, index) {
  var result = array.slice();
  result.splice(index, 1);
  return result;
};