import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["isCurrentPage", "aria-label", "aria-labelledby", "className", "children", "renderMenuContent", "menuLinkName", "focusRef"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { ChevronDown16 } from '@carbon/icons-react';
import cx from 'classnames';
import React from 'react';
import PropTypes from 'prop-types';
import { keys, matches } from '../../internal/keyboard';
import { AriaLabelPropType } from '../../prop-types/AriaPropTypes';
import { PrefixContext } from '../../internal/usePrefix';
/**
 * `HeaderMenu` is used to render submenu's in the `Header`. Most often children
 * will be a `HeaderMenuItem`. It handles certain keyboard events to help
 * with managing focus. It also passes along refs to each child so that it can
 * help manage focus state of its children.
 */

var HeaderMenu = /*#__PURE__*/function (_React$Component) {
  _inherits(HeaderMenu, _React$Component);

  var _super = _createSuper(HeaderMenu);

  function HeaderMenu(props) {
    var _this;

    _classCallCheck(this, HeaderMenu);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "_subMenus", /*#__PURE__*/React.createRef());

    _defineProperty(_assertThisInitialized(_this), "handleOnClick", function (e) {
      var subMenusNode = _this._subMenus.current;

      if (!subMenusNode || !subMenusNode.contains(e.target)) {
        e.preventDefault();
      }

      _this.setState(function (prevState) {
        return {
          expanded: !prevState.expanded
        };
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleOnKeyDown", function (event) {
      // Handle enter or space key for toggling the expanded state of the menu.
      if (matches(event, [keys.Enter, keys.Space])) {
        event.stopPropagation();
        event.preventDefault();

        _this.setState(function (prevState) {
          return {
            expanded: !prevState.expanded
          };
        });

        return;
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleOnBlur", function (event) {
      // Rough guess for a blur event that is triggered outside of our menu or
      // menubar context
      var itemTriggeredBlur = _this.items.find(function (element) {
        return element === event.relatedTarget;
      });

      if (event.relatedTarget && (event.relatedTarget.getAttribute('href') && event.relatedTarget.getAttribute('href') !== '#' || itemTriggeredBlur)) {
        return;
      }

      _this.setState({
        expanded: false,
        selectedIndex: null
      });
    });

    _defineProperty(_assertThisInitialized(_this), "handleMenuButtonRef", function (node) {
      if (_this.props.focusRef) {
        _this.props.focusRef(node);
      }

      _this.menuButtonRef = node;
    });

    _defineProperty(_assertThisInitialized(_this), "handleItemRef", function (index) {
      return function (node) {
        _this.items[index] = node;
      };
    });

    _defineProperty(_assertThisInitialized(_this), "handleMenuClose", function (event) {
      // Handle ESC keydown for closing the expanded menu.
      if (matches(event, [keys.Escape]) && _this.state.expanded) {
        event.stopPropagation();
        event.preventDefault();

        _this.setState(function () {
          return {
            expanded: false,
            selectedIndex: null
          };
        }); // Return focus to menu button when the user hits ESC.


        _this.menuButtonRef.focus();

        return;
      }
    });

    _defineProperty(_assertThisInitialized(_this), "_renderMenuItem", function (item, index) {
      if ( /*#__PURE__*/React.isValidElement(item)) {
        return /*#__PURE__*/React.cloneElement(item, {
          ref: _this.handleItemRef(index)
        });
      }
    });

    _this.state = {
      // Used to manage the expansion state of the menu
      expanded: false,
      // Refers to the menuitem that is currently focused
      // Note: children should have `role="menuitem"` on node consuming ref
      selectedIndex: null
    };
    _this.items = [];
    return _this;
  }
  /**
   * Toggle the expanded state of the menu on click.
   */


  _createClass(HeaderMenu, [{
    key: "render",
    value: function render() {
      var _cx;

      var prefix = this.context;

      var _this$props = this.props,
          isCurrentPage = _this$props.isCurrentPage,
          ariaLabel = _this$props['aria-label'],
          ariaLabelledBy = _this$props['aria-labelledby'],
          customClassName = _this$props.className,
          children = _this$props.children,
          MenuContent = _this$props.renderMenuContent,
          menuLinkName = _this$props.menuLinkName,
          focusRef = _this$props.focusRef,
          rest = _objectWithoutProperties(_this$props, _excluded);

      var accessibilityLabel = {
        'aria-label': ariaLabel,
        'aria-labelledby': ariaLabelledBy
      };
      var className = cx((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--header__submenu"), true), _defineProperty(_cx, customClassName, true), _defineProperty(_cx, "".concat(prefix, "--header__submenu--current"), isCurrentPage), _cx)); // Notes on eslint comments and based on the examples in:
      // https://www.w3.org/TR/wai-aria-practices/examples/menubar/menubar-1/menubar-1.html#
      // - The focus is handled by the <a> menuitem, onMouseOver is for mouse
      // users
      // - aria-haspopup can definitely have the value "menu"
      // - aria-expanded is on their example node with role="menuitem"
      // - href can be set to javascript:void(0), ideally this will be a button

      return /*#__PURE__*/React.createElement("li", _extends({}, rest, {
        className: className,
        onKeyDown: this.handleMenuClose,
        onClick: this.handleOnClick,
        onBlur: this.handleOnBlur
      }), /*#__PURE__*/React.createElement("a", _extends({
        // eslint-disable-line jsx-a11y/role-supports-aria-props,jsx-a11y/anchor-is-valid
        "aria-haspopup": "menu" // eslint-disable-line jsx-a11y/aria-proptypes
        ,
        "aria-expanded": this.state.expanded,
        className: "".concat(prefix, "--header__menu-item ").concat(prefix, "--header__menu-title"),
        href: "#",
        onKeyDown: this.handleOnKeyDown,
        ref: this.handleMenuButtonRef,
        tabIndex: 0
      }, accessibilityLabel), menuLinkName, MenuContent ? /*#__PURE__*/React.createElement(MenuContent, null) : /*#__PURE__*/React.createElement(ChevronDown16, {
        className: "".concat(this.context, "--header__menu-arrow")
      })), /*#__PURE__*/React.createElement("ul", _extends({}, accessibilityLabel, {
        ref: this._subMenus,
        className: "".concat(prefix, "--header__menu")
      }), React.Children.map(children, this._renderMenuItem)));
    }
    /**
     * We capture the `ref` for each child inside of `this.items` to properly
     * manage focus. In addition to this focus management, all items receive a
     * `tabIndex: -1` so the user won't hit a large number of items in their tab
     * sequence when they might not want to go through all the items.
     */

  }]);

  return HeaderMenu;
}(React.Component);

_defineProperty(HeaderMenu, "propTypes", _objectSpread(_objectSpread({}, AriaLabelPropType), {}, {
  /**
   * Provide a custom ref handler for the menu button
   */
  focusRef: PropTypes.func,

  /**
   * Provide a label for the link text
   */
  menuLinkName: PropTypes.string.isRequired,

  /**
   * Optional component to render instead of string
   */
  renderMenuContent: PropTypes.func,

  /**
   * Optionally provide a tabIndex for the underlying menu button
   */
  tabIndex: PropTypes.number
}));

_defineProperty(HeaderMenu, "contextType", PrefixContext);

var HeaderMenuForwardRef = /*#__PURE__*/React.forwardRef(function (props, ref) {
  return /*#__PURE__*/React.createElement(HeaderMenu, _extends({}, props, {
    focusRef: ref
  }));
});
HeaderMenuForwardRef.displayName = 'HeaderMenu';
export default HeaderMenuForwardRef;