/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { default as TimePicker } from './TimePicker';
import { render, screen, fireEvent } from '@testing-library/react';
import userEvent from '@testing-library/user-event';
describe('TimePicker', function () {
  describe('input', function () {
    it('renders as expected', function () {
      render( /*#__PURE__*/React.createElement(TimePicker, {
        id: "time-picker"
      }));
      expect(screen.getByRole('textbox')).toBeInTheDocument();
    });
    it('passes classNames as expected', function () {
      render( /*#__PURE__*/React.createElement(TimePicker, {
        id: "time-picker",
        className: "\uD83D\uDE80"
      }));
      expect(screen.getByRole('textbox')).toHaveClass('🚀');
    });
    it('should set type as expected', function () {
      render( /*#__PURE__*/React.createElement(TimePicker, {
        id: "time-picker"
      }));
      expect(screen.getByRole('textbox')).toHaveAttribute('type', 'text');
    });
    it('should set value as expected', function () {
      render( /*#__PURE__*/React.createElement(TimePicker, {
        id: "time-picker",
        value: "\uD83D\uDC36"
      }));
      expect(screen.getByRole('textbox')).toHaveAttribute('value', '🐶');
    });
    it('should set disabled as expected', function () {
      var onClick = jest.fn();
      render( /*#__PURE__*/React.createElement(TimePicker, {
        id: "time-picker",
        onClick: onClick,
        disabled: true
      }));
      fireEvent.click(screen.getByRole('textbox'));
      expect(onClick).not.toHaveBeenCalled();
    });
    it('should set placeholder as expected', function () {
      render( /*#__PURE__*/React.createElement(TimePicker, {
        id: "time-picker",
        placeholder: "\uD83E\uDDF8"
      }));
      expect(screen.getByPlaceholderText('🧸')).toBeInTheDocument();
    });
  });
  describe('label', function () {
    it('does not render a label by default', function () {
      render( /*#__PURE__*/React.createElement(TimePicker, {
        id: "time-picker"
      }));
      expect(screen.queryByLabelText('🐳')).not.toBeInTheDocument();
    });
    it('renders a label as expected', function () {
      render( /*#__PURE__*/React.createElement(TimePicker, {
        id: "time-picker",
        labelText: "\uD83D\uDC33"
      }));
      expect(screen.getByLabelText('🐳')).toBeInTheDocument();
    });
  });
  describe('events', function () {
    it('should write text inside the textbox', function () {
      render( /*#__PURE__*/React.createElement(TimePicker, {
        id: "time-picker"
      }));
      userEvent.type(screen.getByRole('textbox'), '🧛');
      expect(screen.getByRole('textbox')).toHaveValue('🧛');
    });
  });
});