import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["children", "className", "id", "labelText", "type", "pattern", "onChange", "onClick", "onBlur", "placeholder", "maxLength", "invalidText", "invalid", "hideLabel", "light", "size"];

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React, { Component } from 'react';
import classNames from 'classnames';
import { settings } from 'carbon-components';
import { FeatureFlagContext } from '../FeatureFlags';
var prefix = settings.prefix;

var TimePicker = /*#__PURE__*/function (_Component) {
  _inherits(TimePicker, _Component);

  var _super = _createSuper(TimePicker);

  function TimePicker() {
    var _this;

    _classCallCheck(this, TimePicker);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {});

    return _this;
  }

  _createClass(TimePicker, [{
    key: "render",
    value: function render() {
      var _this2 = this,
          _classNames2,
          _classNames3;

      var _this$props = this.props,
          children = _this$props.children,
          className = _this$props.className,
          id = _this$props.id,
          labelText = _this$props.labelText,
          type = _this$props.type,
          pattern = _this$props.pattern,
          _onChange = _this$props.onChange,
          _onClick = _this$props.onClick,
          _onBlur = _this$props.onBlur,
          placeholder = _this$props.placeholder,
          maxLength = _this$props.maxLength,
          invalidText = _this$props.invalidText,
          invalid = _this$props.invalid,
          hideLabel = _this$props.hideLabel,
          light = _this$props.light,
          size = _this$props.size,
          other = _objectWithoutProperties(_this$props, _excluded);

      var scope = this.context;
      var enabled;

      if (scope.enabled) {
        enabled = scope.enabled('enable-v11-release');
      }

      var timePickerInputProps = {
        className: classNames("".concat(prefix, "--time-picker__input-field"), "".concat(prefix, "--text-input"), [enabled ? null : className], _defineProperty({}, "".concat(prefix, "--text-input--light"), light)),
        onChange: function onChange(evt) {
          if (!other.disabled) {
            _this2.setState({
              value: evt.target.value
            });

            _onChange(evt);
          }
        },
        onClick: function onClick(evt) {
          if (!other.disabled) {
            _this2.setState({
              value: evt.target.value
            });

            _onClick(evt);
          }
        },
        onBlur: function onBlur(evt) {
          if (!other.disabled) {
            _this2.setState({
              value: evt.target.value
            });

            _onBlur(evt);
          }
        },
        pattern: pattern,
        placeholder: placeholder,
        maxLength: maxLength,
        id: id,
        type: type,
        value: this.state.value
      };
      var timePickerClasses = classNames((_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefix, "--time-picker"), true), _defineProperty(_classNames2, "".concat(prefix, "--time-picker--light"), light), _defineProperty(_classNames2, "".concat(prefix, "--time-picker--invalid"), invalid), _defineProperty(_classNames2, "".concat(prefix, "--time-picker--").concat(size), size), _defineProperty(_classNames2, className, className), _classNames2));
      var labelClasses = classNames("".concat(prefix, "--label"), (_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefix, "--visually-hidden"), hideLabel), _defineProperty(_classNames3, "".concat(prefix, "--label--disabled"), other.disabled), _classNames3));
      var label = labelText ? /*#__PURE__*/React.createElement("label", {
        htmlFor: id,
        className: labelClasses
      }, labelText) : null;
      var error = invalid ? /*#__PURE__*/React.createElement("div", {
        className: "".concat(prefix, "--form-requirement")
      }, invalidText) : null;
      return /*#__PURE__*/React.createElement("div", {
        className: enabled ? classNames("".concat(prefix, "--form-item"), className) : "".concat(prefix, "--form-item")
      }, label, /*#__PURE__*/React.createElement("div", {
        className: timePickerClasses
      }, /*#__PURE__*/React.createElement("div", {
        className: "".concat(prefix, "--time-picker__input")
      }, /*#__PURE__*/React.createElement("input", _extends({}, other, timePickerInputProps, {
        "data-invalid": invalid ? invalid : undefined
      }))), children), error);
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref, state) {
      var value = _ref.value;
      var prevValue = state.prevValue;
      return prevValue === value ? null : {
        value: value,
        prevValue: value
      };
    }
  }]);

  return TimePicker;
}(Component);

_defineProperty(TimePicker, "propTypes", {
  /**
   * Pass in the children that will be rendered next to the form control
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify whether the `<input>` should be disabled
   */
  disabled: PropTypes.bool,

  /**
   * Specify whether you want the underlying label to be visually hidden
   */
  hideLabel: PropTypes.bool,

  /**
   * Specify a custom `id` for the `<input>`
   */
  id: PropTypes.string.isRequired,

  /**
   * Specify whether the control is currently invalid
   */
  invalid: PropTypes.bool,

  /**
   * Provide the text that is displayed when the control is in an invalid state
   */
  invalidText: PropTypes.node,

  /**
   * Provide the text that will be read by a screen reader when visiting this
   * control
   */
  labelText: PropTypes.node,

  /**
   * `true` to use the light version. For use on $ui-01 backgrounds only.
   * Don't use this to make tile background color same as container background color.
   */
  light: PropTypes.bool,

  /**
   * Specify the maximum length of the time string in `<input>`
   */
  maxLength: PropTypes.number,

  /**
   * Optionally provide an `onBlur` handler that is called whenever the
   * `<input>` loses focus
   */
  onBlur: PropTypes.func,

  /**
   * Optionally provide an `onChange` handler that is called whenever `<input>`
   * is updated
   */
  onChange: PropTypes.func,

  /**
   * Optionally provide an `onClick` handler that is called whenever the
   * `<input>` is clicked
   */
  onClick: PropTypes.func,

  /**
   * Specify the regular expression working as the pattern of the time string in `<input>`
   */
  pattern: PropTypes.string,

  /**
   * Specify the placeholder attribute for the `<input>`
   */
  placeholder: PropTypes.string,

  /**
   * Specify the size of the Time Picker. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   * TODO V11: remove `xl` (replaced with lg)
   */
  size: PropTypes.oneOf(['sm', 'md', 'lg', 'xl']),

  /**
   * Specify the type of the `<input>`
   */
  type: PropTypes.string,

  /**
   * Specify the value of the `<input>`
   */
  value: PropTypes.string
});

_defineProperty(TimePicker, "defaultProps", {
  type: 'text',
  pattern: '(1[012]|[1-9]):[0-5][0-9](\\s)?',
  placeholder: 'hh:mm',
  maxLength: 5,
  invalidText: 'Invalid time format.',
  invalid: false,
  disabled: false,
  onChange: function onChange() {},
  onClick: function onClick() {},
  onBlur: function onBlur() {},
  light: false
});

_defineProperty(TimePicker, "contextType", FeatureFlagContext);

export { TimePicker as default };