import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, select, text } from '@storybook/addon-knobs';
import { TextInput } from '../../index';
import TextInputSkeleton from '../TextInput/TextInput.Skeleton';
import FluidForm from '../FluidForm/FluidForm';
import mdx from './TextInput.mdx';
import { FeatureFlags } from '../FeatureFlags';
var types = {
  None: '',
  'Text (text)': 'text',
  'For email (email)': 'email',
  'For password (password)': 'password'
};
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var ControlledPasswordInputApp = /*#__PURE__*/React.forwardRef(function ControlledPasswordInputApp(props, ref) {
  var _useState = useState('password'),
      _useState2 = _slicedToArray(_useState, 2),
      type = _useState2[0],
      setType = _useState2[1];

  var togglePasswordVisibility = function togglePasswordVisibility() {
    setType(type === 'password' ? 'text' : 'password');
  };

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(TextInput.PasswordInput, _extends({
    type: type,
    togglePasswordVisibility: togglePasswordVisibility,
    ref: ref
  }, props)), /*#__PURE__*/React.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setType('text');
    }
  }, "Show password"), /*#__PURE__*/React.createElement("button", {
    type: "button",
    onClick: function onClick() {
      return setType('password');
    }
  }, "Hide password"));
});
var props = {
  SharedInputProps: function SharedInputProps() {
    return {
      className: 'some-class',
      id: 'test2',
      defaultValue: text('Default value (defaultValue)', 'This is not a default value'),
      size: select('Field size (size)', sizes, undefined) || undefined,
      labelText: text('Label text (labelText)', 'Text input label'),
      placeholder: text('Placeholder text (placeholder)', 'Placeholder text'),
      light: boolean('Light variant (light)', false),
      disabled: boolean('Disabled (disabled)', false),
      hideLabel: boolean('No label (hideLabel)', false),
      invalid: boolean('Show form validation UI (invalid)', false),
      invalidText: text('Form validation UI content (invalidText)', 'A valid value is required'),
      warn: boolean('Show warning state (warn)', false),
      warnText: text('Warning state text (warnText)', 'This will overwrite your current settings'),
      helperText: text('Helper text (helperText)', 'Optional help text'),
      inline: boolean('Inline variant (inline)', false),
      onClick: action('onClick'),
      onChange: action('onChange')
    };
  },
  TextInputProps: function TextInputProps() {
    return {
      readOnly: boolean('Readonly variant (readOnly)', false)
    };
  },
  PasswordInputProps: function PasswordInputProps() {
    return {
      tooltipPosition: select('Tooltip position (tooltipPosition)', ['top', 'right', 'bottom', 'left'], 'bottom'),
      tooltipAlignment: select('Tooltip alignment (tooltipAlignment)', ['start', 'center', 'end'], 'center'),
      hidePasswordLabel: text('"Hide password" tooltip label for password visibility toggle (hidePasswordLabel)', 'Hide password'),
      showPasswordLabel: text('"Show password" tooltip label for password visibility toggle (showPasswordLabel)', 'Show password')
    };
  }
};
TextInput.displayName = 'TextInput';
export default {
  title: 'Components/TextInput',
  decorators: [withKnobs],
  parameters: {
    component: TextInput,
    docs: {
      page: mdx
    },
    subcomponents: {
      TextInputSkeleton: TextInputSkeleton,
      'TextInput.PasswordInput': TextInput.PasswordInput
    }
  }
};
export var classNameChangeTest = function classNameChangeTest() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(TextInput, _extends({
    defaultValue: "The class should be added to the label",
    labelText: "Text input label",
    helperText: "Optional help text",
    type: select('Form control type (type)', types, 'text')
  }, props.TextInputProps(), {
    className: "TEST_CLASS"
  })), /*#__PURE__*/React.createElement("br", null), /*#__PURE__*/React.createElement(FeatureFlags, {
    flags: {
      'enable-v11-release': true
    }
  }, /*#__PURE__*/React.createElement(TextInput, _extends({
    defaultValue: "The class should be added to the wrapper",
    labelText: "Text input label",
    helperText: "Optional help text",
    type: select('Form control type (type)', types, 'text')
  }, props.TextInputProps(), {
    className: "TEST_CLASS"
  }))));
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(TextInput, _extends({
    type: select('Form control type (type)', types, 'text')
  }, props.SharedInputProps(), props.TextInputProps()));
};
Default.parameters = {
  info: {
    text: "\n        Text fields enable the user to interact with and input data. A single line\n        field is used when the input anticipated by the user is a single line of\n        text as opposed to a paragraph.\n        The default type is 'text' and its value can be either 'string' or 'number'.\n      "
  }
};
export var Fluid = function Fluid() {
  return /*#__PURE__*/React.createElement(FluidForm, null, /*#__PURE__*/React.createElement(TextInput, _extends({
    type: select('Form control type (type)', types, 'text')
  }, props.SharedInputProps(), props.TextInputProps())));
};
Fluid.parameters = {
  info: {
    text: "\n        Text fields enable the user to interact with and input data. A single line\n        field is used when the input anticipated by the user is a single line of\n        text as opposed to a paragraph.\n        The default type is 'text' and its value can be either 'string' or 'number'.\n      "
  }
};
export var TogglePasswordVisibility = function TogglePasswordVisibility() {
  return /*#__PURE__*/React.createElement(TextInput.PasswordInput, _extends({}, props.SharedInputProps(), props.PasswordInputProps()));
};
TogglePasswordVisibility.storyName = 'Toggle password visibility';
TogglePasswordVisibility.parameters = {
  info: {
    text: "\n      Text field with password visibility toggle.\n    "
  }
};
export var FullyControlledTogglePasswordVisibility = function FullyControlledTogglePasswordVisibility() {
  ControlledPasswordInputApp.__docgenInfo = _objectSpread(_objectSpread({}, TextInput.PasswordInput.__docgenInfo), {}, {
    props: _objectSpread({}, TextInput.PasswordInput.__docgenInfo.props)
  });
  return /*#__PURE__*/React.createElement(ControlledPasswordInputApp, _extends({}, props.SharedInputProps(), props.PasswordInputProps()));
};
FullyControlledTogglePasswordVisibility.storyName = 'Fully controlled toggle password visibility';
FullyControlledTogglePasswordVisibility.parameters = {
  info: {
    text: "\n    Fully controlled text field with password visibility toggle.\n  "
  }
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement(TextInputSkeleton, null);
};
Skeleton.storyName = 'skeleton';
Skeleton.parameters = {
  info: {
    text: "\n        Placeholder skeleton state to use when content is loading.\n        "
  }
};