import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["as", "children", "dir"];

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React, { useContext } from 'react';
import { TextDirectionContext } from './TextDirectionContext';

function Text(_ref) {
  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'span' : _ref$as,
      children = _ref.children,
      _ref$dir = _ref.dir,
      dir = _ref$dir === void 0 ? 'auto' : _ref$dir,
      rest = _objectWithoutProperties(_ref, _excluded);

  var context = useContext(TextDirectionContext);
  var textProps = {};

  var value = _objectSpread({}, context);

  if (!context) {
    textProps.dir = dir;
    value.direction = dir;
  } else {
    var parentDirection = context.direction,
        getTextDirection = context.getTextDirection;

    if (getTextDirection && getTextDirection.current) {
      var text = getTextFromChildren(children);
      var override = getTextDirection.current(text);

      if (parentDirection !== override) {
        textProps.dir = override;
        value.direction = override;
      } else if (parentDirection === 'auto') {
        textProps.dir = override;
      }
    } else if (parentDirection !== dir) {
      textProps.dir = dir;
      value.direction = dir;
    } else if (parentDirection === 'auto') {
      textProps.dir = dir;
    }
  }

  return /*#__PURE__*/React.createElement(TextDirectionContext.Provider, {
    value: value
  }, /*#__PURE__*/React.createElement(BaseComponent, _extends({}, rest, textProps), children));
}

Text.propTypes = {
  /**
   * Provide a custom element type used to render the outermost node
   */
  as: PropTypes.oneOfType([PropTypes.func, PropTypes.string, PropTypes.elementType]),

  /**
   * Provide child elements or text to be rendered inside of this component
   */
  children: PropTypes.node.isRequired,

  /**
   * Specify the text direction to be used for this component and any of its
   * children
   */
  dir: PropTypes.oneOf(['ltr', 'rtl', 'auto'])
};

function getTextFromChildren(children) {
  if (typeof children === 'string') {
    return children;
  }

  var text = React.Children.map(children, function (child) {
    if (typeof child === 'string') {
      return child;
    }

    return null;
  }).filter(function (text) {
    return text !== null;
  });

  if (text.length === 1) {
    return text[0];
  }

  return text;
}

export { Text };