/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { LayoutDirection } from '../Layout';
import { TextDirection, Text } from '../Text';
import RadioButtonGroup from '../RadioButtonGroup';
import RadioButton from '../RadioButton';
import Button from '../Button';
import Dropdown from '../Dropdown';
import ContentSwitcher from '../ContentSwitcher';
import Switch from '../Switch';
import { Heading } from '../Heading';
import mdx from './Text.mdx';
export default {
  title: 'Experimental/unstable_Text',
  parameters: {
    component: Text,
    docs: {
      page: mdx
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(Text, null, "Hello world")), /*#__PURE__*/React.createElement("p", null, /*#__PURE__*/React.createElement(Text, null, "\u0644\u0643\u0646 \u0644\u0627 \u0628\u062F \u0623\u0646 \u0623\u0648\u0636\u062D \u0644\u0643 \u0623\u0646 \u0643\u0644")));
};
export var LayoutAndText = function LayoutAndText() {
  return /*#__PURE__*/React.createElement(LayoutDirection, {
    dir: "ltr"
  }, /*#__PURE__*/React.createElement("p", null, "Ipsum ipsa repellat doloribus magni architecto totam Laborum maxime ratione nobis voluptatibus facilis nostrum, necessitatibus magnam Maxime esse consequatur nemo sit repellat Dignissimos rem nobis hic reprehenderit ducimus? Fuga voluptatem?"), /*#__PURE__*/React.createElement(LayoutDirection, {
    dir: "rtl"
  }, /*#__PURE__*/React.createElement(Text, {
    as: "p"
  }, "\u0627\u0644\u0645\u063A\u0644\u0648\u0637\u0629 \u062D\u0648\u0644 \u0627\u0633\u062A\u0646\u0643\u0627\u0631 \u0627\u0644\u0646\u0634\u0648\u0629 \u0648\u062A\u0645\u062C\u064A\u062F \u0627\u0644\u0623\u0644\u0645 \u0646\u0634\u0623\u062A \u0628\u0627\u0644\u0641\u0639\u0644\u060C \u0648\u0633\u0623\u0639\u0631\u0636 \u0644\u0643 \u0627\u0644\u062A\u0641\u0627\u0635\u064A\u0644 \u0644\u062A\u0643\u062A\u0634\u0641 \u062D\u0642\u064A\u0642\u0629 \u0648\u0623\u0633\u0627\u0633 \u062A\u0644\u0643 \u0627\u0644\u0633\u0639\u0627\u062F\u0629 \u0627\u0644\u0628\u0634\u0631\u064A\u0629\u060C \u0641\u0644\u0627 \u0623\u062D\u062F \u064A\u0631\u0641\u0636 \u0623\u0648 \u064A\u0643\u0631\u0647 \u0623\u0648 \u064A\u062A\u062C\u0646\u0628 \u0627\u0644\u0634\u0639\u0648\u0631 \u0628\u0627\u0644\u0633\u0639\u0627\u062F\u0629\u060C \u0648\u0644\u0643\u0646 \u0628\u0641\u0636\u0644 \u0647\u0624.")), /*#__PURE__*/React.createElement("p", null, "Ipsum ipsa repellat doloribus magni architecto totam Laborum maxime ratione nobis voluptatibus facilis nostrum, necessitatibus magnam Maxime esse consequatur nemo sit repellat Dignissimos rem nobis hic reprehenderit ducimus? Fuga voluptatem?"));
};
export var SetTextDirection = function SetTextDirection() {
  var legendText = 'הכותרת שלי!';
  return /*#__PURE__*/React.createElement(TextDirection, {
    getTextDirection: function getTextDirection(text) {
      if (text === legendText) {
        return 'ltr';
      }

      return 'auto';
    }
  }, /*#__PURE__*/React.createElement(RadioButtonGroup, {
    legendText: legendText,
    name: "radio-button-group",
    defaultSelected: "radio-1",
    style: {
      maxWidth: '400px'
    }
  }, /*#__PURE__*/React.createElement(RadioButton, {
    labelText: "\u05E9\u05DC\u05D5\u05DD \u05E2\u05D5\u05DC\u05DD Option 1",
    value: "radio-1",
    id: "radio-1"
  }), /*#__PURE__*/React.createElement(RadioButton, {
    labelText: "\u05E9\u05DC\u05D5\u05DD \u05E2\u05D5\u05DC\u05DD Option 2",
    value: "radio-1",
    id: "radio-1"
  }), /*#__PURE__*/React.createElement(RadioButton, {
    labelText: "\u05E9\u05DC\u05D5\u05DD \u05E2\u05D5\u05DC\u05DD Option 3",
    value: "radio-1",
    id: "radio-1"
  })));
};
export var UsageExamples = function UsageExamples() {
  var rtlText = 'שלום!!';
  var dropdownItems = [{
    id: 'option-0',
    text: 'Lorem, ipsum dolor sit amet consectetur adipisicing elit.'
  }, {
    id: 'option-1',
    text: rtlText
  }];
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Heading, null, /*#__PURE__*/React.createElement(Text, null, rtlText)), /*#__PURE__*/React.createElement(Button, {
    kind: "ghost"
  }, /*#__PURE__*/React.createElement(Text, null, rtlText)), /*#__PURE__*/React.createElement("div", {
    style: {
      width: 400
    }
  }, /*#__PURE__*/React.createElement(Dropdown, {
    id: "default",
    titleText: "Using <Text> with `itemToElement`",
    helperText: "This is some helper text",
    label: "Dropdown menu options",
    items: dropdownItems,
    itemToElement: function itemToElement(item) {
      return /*#__PURE__*/React.createElement(Text, null, item.text);
    }
  })), /*#__PURE__*/React.createElement(ContentSwitcher, {
    helperText: "Using <Text> within <Switch>",
    onChange: function onChange() {}
  }, /*#__PURE__*/React.createElement(Switch, {
    name: "one"
  }, /*#__PURE__*/React.createElement(Text, null, rtlText)), /*#__PURE__*/React.createElement(Switch, {
    name: "two",
    text: "Second section"
  }), /*#__PURE__*/React.createElement(Switch, {
    name: "three",
    text: "Third section"
  })));
};