/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import 'carbon-components/scss/components/tag/_tag.scss';
import React from 'react';
import { mount } from '@cypress/react';
import Tag from './Tag';
import TagSkeleton from './Tag.Skeleton';
import { Tag16 } from '@carbon/icons-react';
describe('Tag', function () {
  beforeEach(function () {
    mount( /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Tag, null, "This is a tag"), /*#__PURE__*/React.createElement(Tag, {
      onClick: function onClick() {}
    }, "This is an interactive tag"), /*#__PURE__*/React.createElement(Tag, {
      size: "sm"
    }, "This is a small tag"), /*#__PURE__*/React.createElement(Tag, {
      filter: true
    }, "This is a filter tag"), /*#__PURE__*/React.createElement(Tag, {
      renderIcon: Tag16
    }, "Custom icon"), /*#__PURE__*/React.createElement(Tag, {
      filter: true,
      disabled: true
    }, "Disabled filter tag"), /*#__PURE__*/React.createElement(Tag, {
      type: "magenta"
    }, "magenta"), /*#__PURE__*/React.createElement(Tag, {
      type: "red"
    }, "red"), /*#__PURE__*/React.createElement(Tag, {
      type: "purple"
    }, "purple"), /*#__PURE__*/React.createElement(Tag, {
      type: "blue"
    }, "blue"), /*#__PURE__*/React.createElement(Tag, {
      type: "cyan"
    }, "cyan"), /*#__PURE__*/React.createElement(Tag, {
      type: "teal"
    }, "teal"), /*#__PURE__*/React.createElement(Tag, {
      type: "green"
    }, "green"), /*#__PURE__*/React.createElement(Tag, {
      type: "gray"
    }, "gray"), /*#__PURE__*/React.createElement(Tag, {
      type: "cool-gray"
    }, "cool-gray"), /*#__PURE__*/React.createElement(Tag, {
      type: "warm-gray"
    }, "warm-gray"), /*#__PURE__*/React.createElement(Tag, {
      type: "high-contrast"
    }, "high-contrast"), /*#__PURE__*/React.createElement(TagSkeleton, null), /*#__PURE__*/React.createElement(TagSkeleton, {
      size: "sm"
    })));
  });
  it('should render', function () {
    cy.findByText(/warm-gray/).should('be.visible'); // snapshots should always be taken _after_ an assertion that
    // a element/component should be visible. This is to ensure
    // the DOM has settled and the element has fully loaded.

    cy.percySnapshot();
  });
});