/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { Tabs, TabList, Tab, TabPanels, TabPanel } from './Tabs';
import Button from '../../Button';
import TabsSkeleton from './Tabs.Skeleton';
import { Monster20, Corn20, Bat20 } from '@carbon/icons-react';
import { unstable_FeatureFlags as FeatureFlags } from 'carbon-components-react';
export default {
  title: 'Components/Tabs',
  decorators: [function (Story) {
    return /*#__PURE__*/React.createElement(FeatureFlags, {
      flags: {
        'enable-v11-release': true
      }
    }, /*#__PURE__*/React.createElement(Story, null));
  }],
  parameters: {
    component: Tabs,
    subcomponents: {
      TabList: TabList,
      Tab: Tab,
      TabPanels: TabPanels,
      TabPanel: TabPanel
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(Tabs, null, /*#__PURE__*/React.createElement(TabList, {
    "aria-label": "List of tabs"
  }, /*#__PURE__*/React.createElement(Tab, null, "Tab Label 1"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 2"), /*#__PURE__*/React.createElement(Tab, {
    disabled: true
  }, "Tab Label 3"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 4 with a very long long label"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 5")), /*#__PURE__*/React.createElement(TabPanels, null, /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 1 ", /*#__PURE__*/React.createElement(Button, null, "Example button")), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 2"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 3"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 4"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 5")));
};
export var IconOnly = function IconOnly() {
  return /*#__PURE__*/React.createElement(Tabs, null, /*#__PURE__*/React.createElement(TabList, {
    "aria-label": "List of tabs"
  }, /*#__PURE__*/React.createElement(Tab, {
    disabled: true
  }, /*#__PURE__*/React.createElement(Monster20, null)), /*#__PURE__*/React.createElement(Tab, null, /*#__PURE__*/React.createElement(Corn20, null)), /*#__PURE__*/React.createElement(Tab, null, /*#__PURE__*/React.createElement(Bat20, null))), /*#__PURE__*/React.createElement(TabPanels, null, /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 1"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 2"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 3")));
};
export var Contained = function Contained() {
  return /*#__PURE__*/React.createElement(Tabs, null, /*#__PURE__*/React.createElement(TabList, {
    "aria-label": "List of tabs",
    contained: true
  }, /*#__PURE__*/React.createElement(Tab, null, "Tab Label 1"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 2"), /*#__PURE__*/React.createElement(Tab, {
    disabled: true
  }, "Tab Label 3"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 4 with a very long long title"), /*#__PURE__*/React.createElement(Tab, null, "Tab Label 5")), /*#__PURE__*/React.createElement(TabPanels, null, /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 1"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 2 ", /*#__PURE__*/React.createElement(Button, null, "Example button")), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 3"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 4"), /*#__PURE__*/React.createElement(TabPanel, null, "Tab Panel 5")));
};
export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement("div", {
    style: {
      maxWidth: '100%'
    }
  }, /*#__PURE__*/React.createElement(TabsSkeleton, null));
};