import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "contained"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { usePrefix } from '../../../internal/usePrefix';

function Tab() {
  var prefix = usePrefix();
  return /*#__PURE__*/React.createElement("li", {
    className: "".concat(prefix, "--tabs__nav-item")
  }, /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--tabs__nav-link")
  }, /*#__PURE__*/React.createElement("span", null)));
}

function TabsSkeleton(_ref) {
  var className = _ref.className,
      contained = _ref.contained,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var tabClasses = cx(className, "".concat(prefix, "--tabs"), "".concat(prefix, "--skeleton"), _defineProperty({}, "".concat(prefix, "--tabs--contained"), contained));
  return /*#__PURE__*/React.createElement("div", _extends({
    className: tabClasses
  }, rest), /*#__PURE__*/React.createElement("ul", {
    className: "".concat(prefix, "--tabs__nav")
  }, Tab(), Tab(), Tab(), Tab(), Tab()));
}

TabsSkeleton.propTypes = {
  /**
   * Specify an optional className to add.
   */
  className: PropTypes.string,

  /**
   * Provide the type of Tab
   */
  contained: PropTypes.bool
};
export default TabsSkeleton;