import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["rowCount", "border", "className"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { usePrefix } from '../../internal/usePrefix';

var StructuredListSkeleton = function StructuredListSkeleton(_ref) {
  var _cx;

  var rowCount = _ref.rowCount,
      border = _ref.border,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var StructuredListSkeletonClasses = cx(className, (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--skeleton"), true), _defineProperty(_cx, "".concat(prefix, "--structured-list"), true), _defineProperty(_cx, "".concat(prefix, "--structured-list--border"), border), _cx));
  var rows = [];

  for (var i = 0; i < rowCount; i++) {
    rows.push( /*#__PURE__*/React.createElement("div", {
      className: "".concat(prefix, "--structured-list-row"),
      key: i
    }, /*#__PURE__*/React.createElement("div", {
      className: "".concat(prefix, "--structured-list-td")
    }), /*#__PURE__*/React.createElement("div", {
      className: "".concat(prefix, "--structured-list-td")
    }), /*#__PURE__*/React.createElement("div", {
      className: "".concat(prefix, "--structured-list-td")
    })));
  }

  return /*#__PURE__*/React.createElement("div", _extends({
    className: StructuredListSkeletonClasses
  }, rest), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--structured-list-thead")
  }, /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--structured-list-row ").concat(prefix, "--structured-list-row--header-row")
  }, /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--structured-list-th")
  }, /*#__PURE__*/React.createElement("span", null)), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--structured-list-th")
  }, /*#__PURE__*/React.createElement("span", null)), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--structured-list-th")
  }, /*#__PURE__*/React.createElement("span", null)))), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--structured-list-tbody")
  }, rows));
};

StructuredListSkeleton.propTypes = {
  /**
   * Specify whether a border should be added to your StructuredListSkeleton
   */
  border: PropTypes.bool,

  /**
   * Specify an optional className to add.
   */
  className: PropTypes.string,

  /**
   * number of table rows
   */
  rowCount: PropTypes.number
};
StructuredListSkeleton.defaultProps = {
  rowCount: 5,
  border: false
};
export default StructuredListSkeleton;