import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["hideLabel", "className"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import cx from 'classnames';
import { settings } from 'carbon-components';
var prefix = settings.prefix;

var SliderSkeleton = function SliderSkeleton(_ref) {
  var hideLabel = _ref.hideLabel,
      className = _ref.className,
      rest = _objectWithoutProperties(_ref, _excluded);

  return /*#__PURE__*/React.createElement("div", _extends({
    className: cx("".concat(prefix, "--form-item"), className)
  }, rest), !hideLabel && /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--label ").concat(prefix, "--skeleton")
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--slider-container ").concat(prefix, "--skeleton")
  }, /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--slider__range-label")
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--slider")
  }, /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--slider__track")
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--slider__filled-track")
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--slider__thumb")
  })), /*#__PURE__*/React.createElement("span", {
    className: "".concat(prefix, "--slider__range-label")
  })));
};

SliderSkeleton.propTypes = {
  /**
   * Specify an optional className to add to the form item wrapper.
   */
  className: PropTypes.string,

  /**
   * Specify whether the label should be hidden, or not
   */
  hideLabel: PropTypes.bool
};
export default SliderSkeleton;