/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { default as Select, SelectSkeleton } from '../';
import SelectItem from '../../SelectItem';
import SelectItemGroup from '../../SelectItemGroup';
import { Layer } from '../../Layer';
export default {
  title: 'Components/Select',
  decorators: [function (story) {
    return /*#__PURE__*/React.createElement("div", {
      style: {
        width: '400px'
      }
    }, story());
  }],
  parameters: {
    component: Select,
    subcomponents: {
      SelectItem: SelectItem,
      SelectItemGroup: SelectItemGroup,
      SelectSkeleton: SelectSkeleton
    }
  }
};
export var _Default = function _Default() {
  return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(Select, {
    id: "select-1",
    defaultValue: "placeholder-item",
    labelText: "Select an option",
    helperText: "Optional helper text"
  }, /*#__PURE__*/React.createElement(SelectItem, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "Choose an option"
  }), /*#__PURE__*/React.createElement(SelectItemGroup, {
    label: "Category 1"
  }, /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-1",
    text: "Option 1"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-2",
    text: "Option 2"
  })), /*#__PURE__*/React.createElement(SelectItemGroup, {
    label: "Category 2"
  }, /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-3",
    text: "Option 3"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-4",
    text: "Option 4"
  }))));
};
export var Inline = function Inline() {
  return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(Select, {
    inline: true,
    id: "select-1",
    defaultValue: "placeholder-item",
    labelText: "",
    helperText: "Optional helper text"
  }, /*#__PURE__*/React.createElement(SelectItem, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "Choose an option"
  }), /*#__PURE__*/React.createElement(SelectItemGroup, {
    label: "Category 1"
  }, /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-1",
    text: "Option 1"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-2",
    text: "Option 2"
  })), /*#__PURE__*/React.createElement(SelectItemGroup, {
    label: "Category 2"
  }, /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-3",
    text: "Option 3"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-4",
    text: "Option 4"
  }))));
};
export var _Skeleton = function _Skeleton() {
  return /*#__PURE__*/React.createElement("div", {
    "aria-label": "loading select",
    "aria-live": "assertive",
    role: "status",
    tabIndex: "0" // eslint-disable-line jsx-a11y/no-noninteractive-tabindex

  }, /*#__PURE__*/React.createElement(SelectSkeleton, null));
};
export var withLayer = function withLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Select, {
    id: "select-1",
    defaultValue: "placeholder-item",
    labelText: "",
    helperText: "First layer"
  }, /*#__PURE__*/React.createElement(SelectItem, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "Choose an option"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-1",
    text: "Option 1"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-2",
    text: "Option 2"
  })), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(Select, {
    id: "select-1",
    defaultValue: "placeholder-item",
    labelText: "",
    helperText: " Second layer"
  }, /*#__PURE__*/React.createElement(SelectItem, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "Choose an option"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-1",
    text: "Option 1"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-2",
    text: "Option 2"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-3",
    text: "Option 3"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-4",
    text: "Option 4"
  })), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(Select, {
    id: "select-1",
    defaultValue: "placeholder-item",
    labelText: "",
    helperText: "Third layer"
  }, /*#__PURE__*/React.createElement(SelectItem, {
    disabled: true,
    hidden: true,
    value: "placeholder-item",
    text: "Choose an option"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-1",
    text: "Option 1"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-2",
    text: "Option 2"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-3",
    text: "Option 3"
  }), /*#__PURE__*/React.createElement(SelectItem, {
    value: "option-4",
    text: "Option 4"
  })))));
};