import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import classNames from 'classnames';
import { warning } from '../../internal/warning';
import { settings } from 'carbon-components';
import { Legend } from '../Text';
import { FeatureFlagContext } from '../FeatureFlags';
var prefix = settings.prefix;

var RadioButtonGroup = /*#__PURE__*/function (_React$Component) {
  _inherits(RadioButtonGroup, _React$Component);

  var _super = _createSuper(RadioButtonGroup);

  function RadioButtonGroup() {
    var _this;

    _classCallCheck(this, RadioButtonGroup);

    for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
      args[_key] = arguments[_key];
    }

    _this = _super.call.apply(_super, [this].concat(args));

    _defineProperty(_assertThisInitialized(_this), "state", {
      selected: typeof _this.props.valueSelected !== 'undefined' ? _this.props.valueSelected : _this.props.defaultSelected
    });

    _defineProperty(_assertThisInitialized(_this), "getRadioButtons", function () {
      var children = React.Children.map(_this.props.children, function (radioButton) {
        var value = radioButton.props.value;
        /* istanbul ignore if */

        if (typeof radioButton.props.checked !== 'undefined') {
          process.env.NODE_ENV !== "production" ? warning(false, "Instead of using the checked property on the RadioButton, set\n            the defaultSelected property or valueSelected property on the RadioButtonGroup.") : void 0;
        }

        return /*#__PURE__*/React.cloneElement(radioButton, {
          name: _this.props.name,
          key: value,
          value: value,
          onChange: _this.handleChange,
          checked: value === _this.state.selected
        });
      });
      return children;
    });

    _defineProperty(_assertThisInitialized(_this), "handleChange", function (newSelection, value, evt) {
      if (newSelection !== _this.state.selected) {
        _this.setState({
          selected: newSelection
        });

        _this.props.onChange(newSelection, _this.props.name, evt);
      }
    });

    return _this;
  }

  _createClass(RadioButtonGroup, [{
    key: "render",
    value: function render() {
      var _classNames;

      var _this$props = this.props,
          disabled = _this$props.disabled,
          className = _this$props.className,
          orientation = _this$props.orientation,
          labelPosition = _this$props.labelPosition,
          legendText = _this$props.legendText;
      var scope = this.context;
      var enabled;

      if (scope.enabled) {
        enabled = scope.enabled('enable-v11-release');
      }

      var wrapperClasses = classNames("".concat(prefix, "--radio-button-group"), [enabled ? null : className], (_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--radio-button-group--").concat(orientation), orientation === 'vertical'), _defineProperty(_classNames, "".concat(prefix, "--radio-button-group--label-").concat(labelPosition), labelPosition), _classNames));
      return /*#__PURE__*/React.createElement("div", {
        className: enabled ? classNames("".concat(prefix, "--form-item"), className) : "".concat(prefix, "--form-item")
      }, /*#__PURE__*/React.createElement("fieldset", {
        className: wrapperClasses,
        disabled: disabled
      }, legendText && /*#__PURE__*/React.createElement(Legend, {
        className: "".concat(prefix, "--label")
      }, legendText), this.getRadioButtons()));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref, state) {
      var valueSelected = _ref.valueSelected,
          defaultSelected = _ref.defaultSelected;
      var prevValueSelected = state.prevValueSelected;
      return prevValueSelected === valueSelected ? null : {
        selected: typeof valueSelected !== 'undefined' ? valueSelected : defaultSelected,
        prevValueSelected: valueSelected
      };
    }
  }]);

  return RadioButtonGroup;
}(React.Component);

_defineProperty(RadioButtonGroup, "propTypes", {
  /**
   * Provide a collection of <RadioButton> components to render in the group
   */
  children: PropTypes.node,

  /**
   * Provide an optional className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify the <RadioButton> to be selected by default
   */
  defaultSelected: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),

  /**
   * Specify whether the group is disabled
   */
  disabled: PropTypes.bool,

  /**
   * Provide where label text should be placed
   */
  labelPosition: PropTypes.oneOf(['left', 'right']),

  /**
   * Provide a legend to the RadioButtonGroup input that you are
   * exposing to the user
   */
  legendText: PropTypes.node,

  /**
   * Specify the name of the underlying `<input>` nodes
   */
  name: PropTypes.string.isRequired,

  /**
   * Provide an optional `onChange` hook that is called whenever the value of
   * the group changes
   */
  onChange: PropTypes.func,

  /**
   * Provide where radio buttons should be placed
   */
  orientation: PropTypes.oneOf(['horizontal', 'vertical']),

  /**
   * Specify the value that is currently selected in the group
   */
  valueSelected: PropTypes.oneOfType([PropTypes.string, PropTypes.number])
});

_defineProperty(RadioButtonGroup, "defaultProps", {
  orientation: 'horizontal',
  labelPosition: 'right',
  onChange:
  /* istanbul ignore next */
  function onChange() {}
});

_defineProperty(RadioButtonGroup, "contextType", FeatureFlagContext);

export { RadioButtonGroup as default };