import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/**
 * Copyright IBM Corp. 2021
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState, useEffect } from 'react';
import { withKnobs, text, boolean, number } from '@storybook/addon-knobs';
import ProgressBar from '../ProgressBar';

var props = function props() {
  return {
    label: text('Label text (label)', 'Progress bar label'),
    helperText: text('Helper text (helperText)', 'Optional helper text'),
    hideLabel: boolean('Hide the label (hideLabel)', false),
    value: number('Current value (value)', 75),
    max: number('Maximum value (max)', 100)
  };
};

export default {
  title: 'Experimental/unstable_ProgressBar',
  decorators: [withKnobs],
  parameters: {
    component: ProgressBar
  }
};
export var _ProgressBar = function _ProgressBar() {
  return /*#__PURE__*/React.createElement(ProgressBar, {
    label: "Progress bar label",
    helperText: "Optional helper text",
    value: 75
  });
};
_ProgressBar.storyName = 'ProgressBar';
export var Indeterminate = function Indeterminate() {
  return /*#__PURE__*/React.createElement(ProgressBar, {
    label: "Progress bar label",
    helperText: "Optional helper text"
  });
};
export var Example = function Example() {
  var size = 728;

  var _useState = useState(0),
      _useState2 = _slicedToArray(_useState, 2),
      progress = _useState2[0],
      setProgress = _useState2[1];

  useEffect(function () {
    setTimeout(function () {
      var interval = setInterval(function () {
        setProgress(function (currentProgress) {
          var advancement = Math.random() * 8;

          if (currentProgress + advancement < size) {
            return currentProgress + advancement;
          } else {
            clearInterval(interval);
            return size;
          }
        });
      }, 50);
    }, 3000);
  }, []);
  var running = progress > 0;
  var helperText = running ? "".concat(progress.toFixed(1), "MB of ").concat(size, "MB") : 'Fetching assets...';

  if (progress >= size) {
    helperText = 'Done';
  }

  return /*#__PURE__*/React.createElement(ProgressBar, {
    value: running ? progress : null,
    max: size,
    label: "Export data",
    helperText: helperText
  });
};
export var Playground = function Playground() {
  return /*#__PURE__*/React.createElement(ProgressBar, props());
};