import _extends from "@babel/runtime/helpers/extends";

/**
 * Copyright IBM Corp. 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import PaginationNav from '../PaginationNav';
import { mount } from 'enzyme';
import { settings } from 'carbon-components';
import { expect } from 'window-or-global';
var prefix = settings.prefix;
describe('PaginationNav', function () {
  var props = {
    className: 'extra-class',
    totalItems: 24,
    itemsShown: 8,
    page: 1
  };

  var renderPaginationNav = function renderPaginationNav() {
    var additionalProps = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : {};
    return mount( /*#__PURE__*/React.createElement(PaginationNav, _extends({}, props, additionalProps)));
  };

  describe('renders as expected', function () {
    var pagination = renderPaginationNav();
    describe('container', function () {
      it('should render the expected classes', function () {
        var container = pagination.childAt(0);
        expect(container.hasClass("".concat(prefix, "--pagination-nav"))).toBe(true);
        expect(container.hasClass("extra-class")).toBe(true);
      });
    });
    describe('items', function () {
      it('should render n page items, where n = props.itemsShown', function () {
        var pages = pagination.find(".".concat(prefix, "--pagination-nav__page"));
        expect(pages.length).toBe(props.itemsShown);
      });
      it('should render a "previous" button as first item', function () {
        var button = pagination.find(".".concat(prefix, "--pagination-nav__list-item")).first().childAt(0).render();
        expect(button.hasClass("".concat(prefix, "--btn"))).toBe(true);
        expect(button.text()).toBe('Previous');
      });
      it('should render a "Next" button as last item', function () {
        var button = pagination.find(".".concat(prefix, "--pagination-nav__list-item")).last().childAt(0).render();
        expect(button.hasClass("".concat(prefix, "--btn"))).toBe(true);
        expect(button.text()).toBe('Next');
      });
      it('should render the expected classes for the active page', function () {
        var activePage = pagination.find(".".concat(prefix, "--pagination-nav__page")).at(props.page);
        expect(activePage.hasClass("".concat(prefix, "--pagination-nav__page--active"))).toBe(true);
      });
      it('should disable "Previous" button when on first page and props.loop = false', function () {
        var i = 0;
        var pNav = renderPaginationNav({
          page: 0,
          loop: false,
          onChange: function onChange() {
            i++;
          }
        });
        var button = pNav.find(".".concat(prefix, "--pagination-nav__list-item")).first().childAt(0);
        expect(button.props().disabled).toBe(true);
        expect(i).toBe(0);
        button.simulate('click');
        expect(i).toBe(0);
      });
    });
    it('should disable "Next" button when on last page and props.loop = false', function () {
      var i = 0;
      var pNav = renderPaginationNav({
        page: 23,
        loop: false,
        onChange: function onChange() {
          i++;
        }
      });
      var button = pNav.find(".".concat(prefix, "--pagination-nav__list-item")).last().childAt(0);
      expect(button.props().disabled).toBe(true);
      expect(i).toBe(0);
      button.simulate('click');
      expect(i).toBe(0);
    });
  });
  describe('behaves as expected', function () {
    describe('direction buttons', function () {
      it('should move to next page when "Next" button is pressed', function () {
        var pagination = renderPaginationNav();
        var pages = pagination.find(".".concat(prefix, "--pagination-nav__page"));
        var activePage = pagination.find(".".concat(prefix, "--pagination-nav__page--active"));
        expect(activePage.matchesElement(pages.get(props.page))).toBe(true);
        pagination.find(".".concat(prefix, "--pagination-nav__list-item")).last().childAt(0).simulate('click');
        pages = pagination.find(".".concat(prefix, "--pagination-nav__page"));
        activePage = pagination.find(".".concat(prefix, "--pagination-nav__page--active"));
        expect(activePage.matchesElement(pages.get(props.page + 1))).toBe(true);
      });
      it('should move to previous page when "Previous" button is pressed', function () {
        var pagination = renderPaginationNav();
        var pages = pagination.find(".".concat(prefix, "--pagination-nav__page"));
        var activePage = pagination.find(".".concat(prefix, "--pagination-nav__page--active"));
        expect(activePage.matchesElement(pages.get(props.page))).toBe(true);
        pagination.find(".".concat(prefix, "--pagination-nav__list-item")).first().childAt(0).simulate('click');
        pages = pagination.find(".".concat(prefix, "--pagination-nav__page"));
        activePage = pagination.find(".".concat(prefix, "--pagination-nav__page--active"));
        expect(activePage.matchesElement(pages.get(props.page - 1))).toBe(true);
      });
      it('should move to page when user clicks on one', function () {
        var pagination = renderPaginationNav();
        var pages = pagination.find(".".concat(prefix, "--pagination-nav__page"));
        var activePage = pagination.find(".".concat(prefix, "--pagination-nav__page--active"));
        expect(activePage.matchesElement(pages.get(props.page))).toBe(true);
        pagination.find(".".concat(prefix, "--pagination-nav__page")).at(4).simulate('click');
        pages = pagination.find(".".concat(prefix, "--pagination-nav__page"));
        activePage = pagination.find(".".concat(prefix, "--pagination-nav__page--active"));
        expect(activePage.matchesElement(pages.get(4))).toBe(true);
      });
      it('should emit onChange when moved to new page', function () {
        var i = 0;
        var pagination = renderPaginationNav({
          onChange: function onChange() {
            i++;
          }
        });
        expect(i).toBe(0);
        pagination.find(".".concat(prefix, "--pagination-nav__list-item")).first().childAt(0).simulate('click');
        expect(i).toBe(1);
        pagination.find(".".concat(prefix, "--pagination-nav__list-item")).last().childAt(0).simulate('click');
        expect(i).toBe(2);
        pagination.find(".".concat(prefix, "--pagination-nav__list-item")).at(2).childAt(0).simulate('click');
        expect(i).toBe(3);
      });
      it('should move to last page when "Previous" button is pressed on first page and props.loop = true', function () {
        var pagination = renderPaginationNav({
          page: 0,
          loop: true
        });
        var pages = pagination.find(".".concat(prefix, "--pagination-nav__page"));
        var activePage = pagination.find(".".concat(prefix, "--pagination-nav__page--active"));
        expect(activePage.matchesElement(pages.get(0))).toBe(true);
        pagination.find(".".concat(prefix, "--pagination-nav__list-item")).first().childAt(0).simulate('click');
        pages = pagination.find(".".concat(prefix, "--pagination-nav__page"));
        activePage = pagination.find(".".concat(prefix, "--pagination-nav__page--active"));
        expect(activePage.matchesElement(pages.get(pages.length - 1))).toBe(true);
      });
      it('should move to first page when "Next" button is pressed on last page and props.loop = true', function () {
        var pagination = renderPaginationNav({
          page: 23,
          loop: true
        });
        var pages = pagination.find(".".concat(prefix, "--pagination-nav__page"));
        var activePage = pagination.find(".".concat(prefix, "--pagination-nav__page--active"));
        expect(activePage.matchesElement(pages.get(pages.length - 1))).toBe(true);
        pagination.find(".".concat(prefix, "--pagination-nav__list-item")).last().childAt(0).simulate('click');
        pages = pagination.find(".".concat(prefix, "--pagination-nav__page"));
        activePage = pagination.find(".".concat(prefix, "--pagination-nav__page--active"));
        expect(activePage.matchesElement(pages.get(0))).toBe(true);
      });
    });
  });
});