import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["backwardText", "children", "className", "disabled", "forwardText", "id", "initialPage", "itemsPerPageText", "itemRangeText", "itemText", "onChange", "pageRangeText", "pageSize", "pageSizes", "pageText", "pagesUnknown", "totalItems"];

/**
 * Copyright IBM Corp. 2016, 2020
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import PropTypes from 'prop-types';
import classnames from 'classnames';
import { settings } from 'carbon-components';
import { CaretRight16, CaretLeft16 } from '@carbon/icons-react';
import Button from '../../Button';
import Select from '../../Select';
import SelectItem from '../../SelectItem';
var prefix = settings.prefix;

function Pagination(_ref) {
  var backwardText = _ref.backwardText,
      children = _ref.children,
      className = _ref.className,
      disabled = _ref.disabled,
      forwardText = _ref.forwardText,
      id = _ref.id,
      initialPage = _ref.initialPage,
      itemsPerPageText = _ref.itemsPerPageText,
      itemRangeText = _ref.itemRangeText,
      itemText = _ref.itemText,
      onChange = _ref.onChange,
      pageRangeText = _ref.pageRangeText,
      pageSize = _ref.pageSize,
      pageSizes = _ref.pageSizes,
      pageText = _ref.pageText,
      pagesUnknown = _ref.pagesUnknown,
      totalItems = _ref.totalItems,
      other = _objectWithoutProperties(_ref, _excluded);

  var _useState = useState(initialPage),
      _useState2 = _slicedToArray(_useState, 2),
      currentPage = _useState2[0],
      setCurrentPage = _useState2[1];

  var _useState3 = useState(pageSize),
      _useState4 = _slicedToArray(_useState3, 2),
      currentPageSize = _useState4[0],
      setCurrentPageSize = _useState4[1];

  var totalPages = totalItems ? Math.max(Math.ceil(totalItems / currentPageSize), 1) : undefined;
  var backButtonDisabled = disabled || currentPage === 1;
  var forwardButtonDisabled = disabled || currentPage === totalPages;

  function onSetPage(newPage) {
    setCurrentPage(Number(newPage));
  }

  function incrementPage() {
    var page = currentPage + 1;
    setCurrentPage(page);
    onChange({
      page: page,
      pageSize: currentPageSize
    });
  }

  function decrementPage() {
    var page = currentPage - 1;
    setCurrentPage(page);
    onChange({
      page: page,
      pageSize: currentPageSize
    });
  }

  var namespace = "".concat(prefix, "--unstable-pagination");
  return /*#__PURE__*/React.createElement("section", _extends({
    className: classnames(namespace, className)
  }, other), /*#__PURE__*/React.createElement("div", {
    className: "".concat(namespace, "__left")
  }, pageSizes && /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement("label", {
    id: "".concat(namespace, "__page-sizer__counter-").concat(id),
    className: "".concat(namespace, "__text"),
    htmlFor: "".concat(namespace, "__page-sizer__input-").concat(id)
  }, itemsPerPageText), /*#__PURE__*/React.createElement(Select, {
    id: "".concat(namespace, "__page-sizer__input-").concat(id),
    className: "".concat(namespace, "__page-sizer"),
    labelText: "",
    hideLabel: true,
    noLabel: true,
    inline: true,
    onChange: function onChange(event) {
      return setCurrentPageSize(Number(event.target.value));
    },
    value: currentPageSize
  }, pageSizes.map(function (size) {
    return /*#__PURE__*/React.createElement(SelectItem, {
      key: size,
      value: size,
      text: String(size)
    });
  }))), /*#__PURE__*/React.createElement("span", {
    className: "".concat(namespace, "__text")
  }, totalItems && !pagesUnknown && itemRangeText(Math.min(currentPageSize * (currentPage - 1) + 1, totalItems), Math.min(currentPage * currentPageSize, totalItems), totalItems), totalItems && pagesUnknown && itemText(currentPageSize * (currentPage - 1) + 1, currentPage * currentPageSize), !totalItems && itemText(currentPageSize * (currentPage - 1) + 1, currentPage * currentPageSize))), /*#__PURE__*/React.createElement("div", {
    className: "".concat(namespace, "__right")
  }, children && totalItems && children({
    currentPage: currentPage,
    currentPageSize: currentPageSize,
    onSetPage: onSetPage,
    totalPages: totalPages
  }), children && totalItems && !pagesUnknown && /*#__PURE__*/React.createElement("span", {
    className: "".concat(namespace, "__text")
  }, pageRangeText('', totalPages)), children && !totalItems && /*#__PURE__*/React.createElement("span", {
    className: "".concat(namespace, "__text")
  }, pageText(currentPage)), !children && /*#__PURE__*/React.createElement("span", {
    className: "".concat(namespace, "__text")
  }, !totalItems ? pageText(currentPage) : pageRangeText(currentPage, totalPages)), /*#__PURE__*/React.createElement(Button, {
    className: classnames("".concat(namespace, "__button"), "".concat(namespace, "__button--backward"), _defineProperty({}, "".concat(namespace, "__button--no-index"), backButtonDisabled)),
    onClick: function onClick() {
      return decrementPage();
    },
    disabled: backButtonDisabled,
    hasIconOnly: true,
    renderIcon: CaretLeft16,
    tooltipAlignment: "center",
    tooltipPosition: "top",
    iconDescription: backwardText
  }), /*#__PURE__*/React.createElement(Button, {
    className: classnames("".concat(namespace, "__button"), "".concat(namespace, "__button--forward"), _defineProperty({}, "".concat(namespace, "__button--no-index"), forwardButtonDisabled)),
    onClick: function onClick() {
      return incrementPage();
    },
    disabled: forwardButtonDisabled,
    hasIconOnly: true,
    renderIcon: CaretRight16,
    tooltipAlignment: "center",
    tooltipPosition: "top",
    iconDescription: forwardText
  })));
}

Pagination.propTypes = {
  /**
   * The description for the backward icon.
   */
  backwardText: PropTypes.string,

  /**
   * The children of the pagination component.
   */
  children: PropTypes.oneOfType([PropTypes.node, PropTypes.func]),

  /**
   * Extra classes to add.
   */
  className: PropTypes.string,

  /**
   * `true` if the backward/forward buttons should be disabled.
   */
  disabled: PropTypes.bool,

  /**
   * The description for the forward icon.
   */
  forwardText: PropTypes.string,

  /** The unique ID of this component instance. */
  id: PropTypes.oneOfType([PropTypes.string, PropTypes.number]),

  /**
   * The initial active page when the component is first mounted.
   */
  initialPage: PropTypes.number,

  /**
   * The function returning a translatable text showing where the current page is,
   * in a manner of the range of items.
   */
  itemRangeText: PropTypes.func,

  /**
   * A variant of `itemRangeText`, used if the total number of items is unknown.
   */
  itemText: PropTypes.func,

  /**
   * The translatable text indicating the number of items per page.
   */
  itemsPerPageText: PropTypes.string,

  /**
   * The callback function called when the current page changes.
   */
  onChange: PropTypes.func,

  /**
   * The function returning a translatable text showing where the current page is,
   * in a manner of the total number of pages.
   */
  pageRangeText: PropTypes.func,

  /**
   * The number dictating how many items a page contains.
   */
  pageSize: PropTypes.number,

  /**
   * The choices for `pageSize`.
   */
  pageSizes: PropTypes.arrayOf(PropTypes.number),

  /**
   * The translatable text showing the current page.
   */
  pageText: PropTypes.func,

  /**
   * `true` if total number of pages is unknown.
   */
  pagesUnknown: PropTypes.bool,

  /**
   * The total number of items.
   * You need to provide total items to calculate total page,
   * which is required by a child like the `PageSelector`
   * to know how many pages to display.
   */
  totalItems: PropTypes.number
};
Pagination.defaultProps = {
  backwardText: 'Previous page',
  className: null,
  children: undefined,
  disabled: false,
  forwardText: 'Next page',
  id: 1,
  itemsPerPageText: 'Items per page:',
  itemRangeText: function itemRangeText(min, max, total) {
    return "".concat(min, "\u2013").concat(max, " of ").concat(total, " items");
  },
  itemText: function itemText(min, max) {
    return "".concat(min, "\u2013").concat(max, " items");
  },
  initialPage: 1,
  pageRangeText: function pageRangeText(current, total) {
    return "".concat(current, " of ").concat(total, " pages");
  },
  pageSize: 10,
  pageSizes: undefined,
  pageText: function pageText(page) {
    return "page ".concat(page);
  },
  pagesUnknown: false,
  totalItems: undefined
};
export default Pagination;