import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _classCallCheck from "@babel/runtime/helpers/classCallCheck";
import _createClass from "@babel/runtime/helpers/createClass";
import _assertThisInitialized from "@babel/runtime/helpers/assertThisInitialized";
import _inherits from "@babel/runtime/helpers/inherits";
import _possibleConstructorReturn from "@babel/runtime/helpers/possibleConstructorReturn";
import _getPrototypeOf from "@babel/runtime/helpers/getPrototypeOf";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
var _excluded = ["className", "disabled", "iconDescription", "id", "hideLabel", "hideSteppers", "label", "max", "min", "step", "value", "readOnly", "invalid", "invalidText", "warn", "warnText", "helperText", "ariaLabel", "light", "allowEmpty", "innerRef", "translateWithId", "isMobile", "size", "defaultValue"];

var _defaultTranslations;

function _createSuper(Derived) { var hasNativeReflectConstruct = _isNativeReflectConstruct(); return function _createSuperInternal() { var Super = _getPrototypeOf(Derived), result; if (hasNativeReflectConstruct) { var NewTarget = _getPrototypeOf(this).constructor; result = Reflect.construct(Super, arguments, NewTarget); } else { result = Super.apply(this, arguments); } return _possibleConstructorReturn(this, result); }; }

function _isNativeReflectConstruct() { if (typeof Reflect === "undefined" || !Reflect.construct) return false; if (Reflect.construct.sham) return false; if (typeof Proxy === "function") return true; try { Boolean.prototype.valueOf.call(Reflect.construct(Boolean, [], function () {})); return true; } catch (e) { return false; } }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React, { Component } from 'react';
import classNames from 'classnames';
import { settings } from 'carbon-components';
import { Add16, Subtract16 } from '@carbon/icons-react';
import * as FeatureFlags from '@carbon/feature-flags';
import mergeRefs from '../../tools/mergeRefs';
import requiredIfValueExists from '../../prop-types/requiredIfValueExists'; // replace "use" prefix to avoid react thinking this is a hook that
// can only be placed in a function component

import { useNormalizedInputProps as getNormalizedInputProps } from '../../internal/useNormalizedInputProps';
import { useControlledStateWithValue } from '../../internal/FeatureFlags';
import deprecate from '../../prop-types/deprecate';
import { FeatureFlagContext } from '../FeatureFlags';
var prefix = settings.prefix;
export var translationIds = {
  'increment.number': 'increment.number',
  'decrement.number': 'decrement.number'
};
var defaultTranslations = (_defaultTranslations = {}, _defineProperty(_defaultTranslations, translationIds['increment.number'], 'Increment number'), _defineProperty(_defaultTranslations, translationIds['decrement.number'], 'Decrement number'), _defaultTranslations);

var capMin = function capMin(min, value) {
  return isNaN(min) || !min && min !== 0 || isNaN(value) || !value && value !== 0 ? value : Math.max(min, value);
};

var capMax = function capMax(max, value) {
  return isNaN(max) || !max && max !== 0 || isNaN(value) || !value && value !== 0 ? value : Math.min(max, value);
};

var NumberInput = /*#__PURE__*/function (_Component) {
  _inherits(NumberInput, _Component);

  var _super = _createSuper(NumberInput);

  function NumberInput(props) {
    var _this;

    _classCallCheck(this, NumberInput);

    _this = _super.call(this, props);

    _defineProperty(_assertThisInitialized(_this), "_inputRef", null);

    _defineProperty(_assertThisInitialized(_this), "handleChange", function (evt) {
      var _this$props = _this.props,
          disabled = _this$props.disabled,
          onChange = _this$props.onChange;

      if (!disabled) {
        evt.persist();
        evt.imaginaryTarget = _this._inputRef;
        var prevValue = _this.state.value;
        var value = evt.target.value;
        var direction = prevValue < value ? 'up' : 'down';

        _this.setState({
          value: value
        }, function () {
          if (useControlledStateWithValue) {
            onChange(evt, {
              value: value,
              direction: direction
            });
          } else if (onChange) {
            onChange(evt, {
              value: value,
              direction: direction
            });
          }
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "handleArrowClick", function (evt, direction) {
      var value = typeof _this.state.value === 'string' ? Number(_this.state.value) : _this.state.value;
      var _this$props2 = _this.props,
          disabled = _this$props2.disabled,
          min = _this$props2.min,
          max = _this$props2.max,
          step = _this$props2.step,
          onChange = _this$props2.onChange,
          onClick = _this$props2.onClick;
      var conditional = direction === 'down' ? min !== undefined && value > min || min === undefined : max !== undefined && value < max || max === undefined;

      if (!disabled && conditional) {
        value = direction === 'down' ? value - step : value + step;
        value = capMax(max, capMin(min, value));
        evt.persist();
        evt.imaginaryTarget = _this._inputRef;

        _this.setState({
          value: value
        }, function () {
          //TO-DO v11: update these events to return the same things --> evt, {value, direction}
          if (useControlledStateWithValue) {
            onClick && onClick(evt, {
              value: value,
              direction: direction
            });
            onChange && onChange(evt, {
              value: value,
              direction: direction
            });
          } else {
            // value added as a 3rd argument rather than in same obj so it doesn't break in v10
            onClick && onClick(evt, direction, value);
            onChange && onChange(evt, direction, value);
          }
        });
      }
    });

    _defineProperty(_assertThisInitialized(_this), "_handleInputRef", function (ref) {
      _this._inputRef = ref;
    });

    _this.isControlled = props.value !== undefined;

    if (useControlledStateWithValue && _this.isControlled) {
      // Skips the logic of setting initial state if this component is controlled
      _this.state = {};
      return _possibleConstructorReturn(_this);
    }

    var _value = useControlledStateWithValue || typeof props.defaultValue !== 'undefined' ? props.defaultValue : props.value;

    _value = _value === undefined ? 0 : _value;

    if (props.min || props.min === 0) {
      _value = Math.max(props.min, _value);
    }

    _this.state = {
      value: _value
    };
    return _this;
  }

  _createClass(NumberInput, [{
    key: "render",
    value: function render() {
      var _classNames,
          _classNames3,
          _classNames5,
          _this2 = this;

      var _this$props3 = this.props,
          className = _this$props3.className,
          disabled = _this$props3.disabled,
          iconDescription = _this$props3.iconDescription,
          id = _this$props3.id,
          hideLabel = _this$props3.hideLabel,
          hideSteppers = _this$props3.hideSteppers,
          label = _this$props3.label,
          max = _this$props3.max,
          min = _this$props3.min,
          step = _this$props3.step,
          value = _this$props3.value,
          readOnly = _this$props3.readOnly,
          invalid = _this$props3.invalid,
          invalidText = _this$props3.invalidText,
          warn = _this$props3.warn,
          warnText = _this$props3.warnText,
          helperText = _this$props3.helperText,
          ariaLabel = _this$props3.ariaLabel,
          light = _this$props3.light,
          allowEmpty = _this$props3.allowEmpty,
          ref = _this$props3.innerRef,
          t = _this$props3.translateWithId,
          isMobile = _this$props3.isMobile,
          size = _this$props3.size,
          defaultValue = _this$props3.defaultValue,
          other = _objectWithoutProperties(_this$props3, _excluded);

      var scope = this.context;
      var enabled;

      if (scope.enabled) {
        enabled = scope.enabled('enable-v11-release');
      }

      var numberInputClasses = classNames("".concat(prefix, "--number ").concat(prefix, "--number--helpertext"), [enabled ? null : className], (_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--number--readonly"), readOnly), _defineProperty(_classNames, "".concat(prefix, "--number--light"), light), _defineProperty(_classNames, "".concat(prefix, "--number--nolabel"), hideLabel), _defineProperty(_classNames, "".concat(prefix, "--number--nosteppers"), hideSteppers), _defineProperty(_classNames, "".concat(prefix, "--number--mobile"), isMobile), _defineProperty(_classNames, "".concat(prefix, "--number--").concat(size), size), _classNames));
      var isInputInvalid; // If the user supplied `invalid` through props, we'll defer to the passed in value

      if (invalid) {
        isInputInvalid = true;
      } else {
        // Otherwise, if we don't allow an empty value then we check to see
        // if the value is empty, or if it is out of range
        if (!allowEmpty && this.state.value === '') {
          isInputInvalid = true;
        } else {
          if (this.state.value !== '' && (this.state.value > max || this.state.value < min)) {
            isInputInvalid = true;
          }
        }
      }

      var normalizedProps = getNormalizedInputProps({
        id: id,
        readOnly: readOnly,
        disabled: disabled,
        invalid: isInputInvalid,
        invalidText: invalidText,
        warn: warn,
        warnText: warnText
      });
      var props = {
        disabled: normalizedProps.disabled,
        id: id,
        max: max,
        min: min,
        step: step,
        onChange: this.handleChange,
        value: useControlledStateWithValue && this.isControlled ? value : this.state.value,
        readOnly: readOnly,
        'aria-label': label ? null : ariaLabel
      };
      var buttonProps = {
        disabled: disabled
      };
      var inputWrapperProps = {};

      if (normalizedProps.invalid) {
        inputWrapperProps['data-invalid'] = true;
      }

      var helperTextClasses = classNames("".concat(prefix, "--form__helper-text"), _defineProperty({}, "".concat(prefix, "--form__helper-text--disabled"), normalizedProps.disabled));
      var helper = helperText ? /*#__PURE__*/React.createElement("div", {
        className: helperTextClasses
      }, helperText) : null;
      var labelClasses = classNames("".concat(prefix, "--label"), (_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefix, "--label--disabled"), normalizedProps.disabled), _defineProperty(_classNames3, "".concat(prefix, "--visually-hidden"), hideLabel), _classNames3));
      var labelText = label ? /*#__PURE__*/React.createElement("label", {
        htmlFor: id,
        className: labelClasses
      }, label) : null;
      var _ref = [t('increment.number'), t('decrement.number')],
          incrementNumLabel = _ref[0],
          decrementNumLabel = _ref[1];
      var wrapperClasses = classNames("".concat(prefix, "--number__input-wrapper"), _defineProperty({}, "".concat(prefix, "--number__input-wrapper--warning"), normalizedProps.warn));
      var iconClasses = classNames((_classNames5 = {}, _defineProperty(_classNames5, "".concat(prefix, "--number__invalid"), normalizedProps.invalid || normalizedProps.warn), _defineProperty(_classNames5, "".concat(prefix, "--number__invalid--warning"), normalizedProps.warn), _defineProperty(_classNames5, "".concat(prefix, "--number__readonly-icon"), readOnly), _classNames5));
      var ariaDescribedBy = null;

      if (normalizedProps.invalid) {
        ariaDescribedBy = normalizedProps.invalidId;
      }

      if (normalizedProps.warn) {
        ariaDescribedBy = normalizedProps.warnId;
      }

      return /*#__PURE__*/React.createElement("div", {
        className: enabled ? classNames("".concat(prefix, "--form-item"), className) : "".concat(prefix, "--form-item")
      }, /*#__PURE__*/React.createElement("div", _extends({
        className: numberInputClasses
      }, inputWrapperProps), function () {
        return /*#__PURE__*/React.createElement(React.Fragment, null, labelText, /*#__PURE__*/React.createElement("div", {
          className: wrapperClasses
        }, /*#__PURE__*/React.createElement("input", _extends({
          "data-invalid": normalizedProps.invalid,
          "aria-invalid": normalizedProps.invalid,
          "aria-describedby": ariaDescribedBy,
          type: "number",
          pattern: "[0-9]*"
        }, other, props, {
          ref: mergeRefs(ref, _this2._handleInputRef)
        })), normalizedProps.icon && /*#__PURE__*/React.createElement(normalizedProps.icon, {
          className: iconClasses
        }), !hideSteppers && /*#__PURE__*/React.createElement("div", {
          className: "".concat(prefix, "--number__controls")
        }, /*#__PURE__*/React.createElement("button", _extends({
          type: "button",
          className: "".concat(prefix, "--number__control-btn down-icon")
        }, buttonProps, {
          onClick: function onClick(evt) {
            return _this2.handleArrowClick(evt, 'down');
          },
          title: decrementNumLabel || iconDescription,
          "aria-label": decrementNumLabel || iconDescription,
          tabIndex: "-1"
        }), /*#__PURE__*/React.createElement(Subtract16, {
          className: "down-icon"
        })), /*#__PURE__*/React.createElement("div", {
          className: "".concat(prefix, "--number__rule-divider")
        }), /*#__PURE__*/React.createElement("button", _extends({
          type: "button",
          className: "".concat(prefix, "--number__control-btn up-icon")
        }, buttonProps, {
          onClick: function onClick(evt) {
            return _this2.handleArrowClick(evt, 'up');
          },
          title: incrementNumLabel || iconDescription,
          "aria-label": incrementNumLabel || iconDescription,
          tabIndex: "-1"
        }), /*#__PURE__*/React.createElement(Add16, {
          className: "up-icon"
        })), /*#__PURE__*/React.createElement("div", {
          className: "".concat(prefix, "--number__rule-divider")
        }))), normalizedProps.validation ? null : helper);
      }(), normalizedProps.validation));
    }
  }], [{
    key: "getDerivedStateFromProps",
    value: function getDerivedStateFromProps(_ref2, state) {
      var value = _ref2.value;
      var prevValue = state.prevValue;

      if (useControlledStateWithValue && value === '' && prevValue !== '') {
        return {
          value: '',
          prevValue: ''
        };
      } // If `useControlledStateWithValue` feature flag is on, do nothing here.
      // Otherwise, do prop -> state sync with "value capping".
      //// Value capping removed in #8965
      //// value: capMax(max, capMin(min, value)), (L223)


      return useControlledStateWithValue || prevValue === value ? null : {
        value: value,
        prevValue: value
      };
    }
    /**
     * The DOM node reference to the `<input>`.
     * @type {HTMLInputElement}
     */

  }]);

  return NumberInput;
}(Component);

_defineProperty(NumberInput, "propTypes", {
  /**
   * `true` to allow empty string.
   */
  allowEmpty: PropTypes.bool,

  /**
   * Provide a description that would be used to best describe the use case of the NumberInput component
   */
  ariaLabel: PropTypes.string,

  /**
   * Specify an optional className to be applied to the wrapper node
   */
  className: PropTypes.string,

  /**
   * Optional starting value for uncontrolled state
   */
  defaultValue: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),

  /**
   * Specify if the control should be disabled, or not
   */
  disabled: PropTypes.bool,

  /**
   * Provide text that is used alongside the control label for additional help
   */
  helperText: PropTypes.node,

  /**
   * Specify whether you want the underlying label to be visually hidden
   */
  hideLabel: PropTypes.bool,

  /**
   * Specify whether you want the steppers to be hidden
   */
  hideSteppers: PropTypes.bool,

  /**
   * Provide a description for up/down icons that can be read by screen readers
   */
  iconDescription: PropTypes.string.isRequired,

  /**
   * Specify a custom `id` for the input
   */
  id: PropTypes.string.isRequired,

  /**
   * Specify if the currently value is invalid.
   */
  invalid: PropTypes.bool,

  /**
   * Message which is displayed if the value is invalid.
   */
  invalidText: PropTypes.node,

  /**
   * `true` to use the mobile variant.
   */
  isMobile: deprecate(PropTypes.bool, "The `isMobile` prop no longer needed as the default NumberInput styles are now identical to the mobile variant styles. This prop will be removed in the next major version of `carbon-components-react`"),

  /**
   * Generic `label` that will be used as the textual representation of what
   * this field is for
   */
  label: PropTypes.node,

  /**
   * `true` to use the light version.
   */
  light: PropTypes.bool,

  /**
   * The maximum value.
   */
  max: PropTypes.number,

  /**
   * The minimum value.
   */
  min: PropTypes.number,

  /**
   * The new value is available in 'imaginaryTarget.value'
   * i.e. to get the value: evt.imaginaryTarget.value
   *
   * * _With_ `useControlledStateWithValue` feature flag, the signature of the event handler will be altered to provide additional context in the second parameter: `onChange(event, { value, direction })` where:
   *   * `event` is the (React) raw event
   *   * `value` is the new value
   *   * `direction` tells you the button you hit is up button or down button
   * * _Without_ this feature flag the event handler has `onChange(event, direction)` signature.
   */
  onChange: !useControlledStateWithValue ? PropTypes.func : requiredIfValueExists(PropTypes.func),

  /**
   * Provide an optional function to be called when the up/down button is clicked
   */
  onClick: PropTypes.func,

  /**
   * Specify if the component should be read-only
   */
  readOnly: PropTypes.bool,

  /**
   * Specify the size of the Number Input. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   * TODO V11: remove `xl` (replaced with lg)
   */
  size: PropTypes.oneOf(['sm', 'md', 'lg', 'xl']),

  /**
   * Specify how much the values should increase/decrease upon clicking on up/down button
   */
  step: PropTypes.number,

  /**
   * Provide custom text for the component for each translation id
   */
  translateWithId: PropTypes.func.isRequired,

  /**
   * Specify the value of the input
   */
  value: PropTypes.oneOfType([PropTypes.number, PropTypes.string]),

  /**
   * Specify whether the control is currently in warning state
   */
  warn: PropTypes.bool,

  /**
   * Provide the text that is displayed when the control is in warning state
   */
  warnText: PropTypes.node
});

_defineProperty(NumberInput, "defaultProps", {
  disabled: false,
  hideLabel: false,
  iconDescription: FeatureFlags.enabled('enable-v11-release') ? undefined : 'choose a number',
  step: 1,
  invalid: false,
  invalidText: FeatureFlags.enabled('enable-v11-release') ? undefined : 'Provide invalidText',
  warn: false,
  warnText: '',
  ariaLabel: 'Numeric input field with increment and decrement buttons',
  helperText: '',
  light: false,
  allowEmpty: false,
  translateWithId: function translateWithId(id) {
    return defaultTranslations[id];
  }
});

_defineProperty(NumberInput, "contextType", FeatureFlagContext);

export { NumberInput };
export default (function () {
  var forwardRef = function forwardRef(props, ref) {
    return /*#__PURE__*/React.createElement(NumberInput, _extends({}, props, {
      innerRef: ref
    }));
  };

  forwardRef.displayName = 'NumberInput';
  return /*#__PURE__*/React.forwardRef(forwardRef);
})();