import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";

var _iconTypes;

var _excluded = ["children", "className", "onClick", "inline"],
    _excluded2 = ["ariaLabel", "className", "iconDescription", "type", "renderIcon", "name", "notificationType"],
    _excluded3 = ["role", "onClose", "onCloseButtonClick", "iconDescription", "statusIconDescription", "className", "children", "kind", "lowContrast", "hideCloseButton", "timeout", "closeOnEscape"],
    _excluded4 = ["children", "role", "onClose", "onCloseButtonClick", "iconDescription", "statusIconDescription", "className", "kind", "lowContrast", "hideCloseButton", "closeOnEscape"],
    _excluded5 = ["actionButtonLabel", "children", "role", "onActionButtonClick", "onClose", "onCloseButtonClick", "iconDescription", "statusIconDescription", "className", "inline", "kind", "lowContrast", "hideCloseButton", "hasFocus", "closeOnEscape"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React, { useEffect, useRef, useState } from 'react';
import cx from 'classnames';
import { settings } from 'carbon-components';
import { Close20, ErrorFilled20, CheckmarkFilled20, WarningFilled20, WarningAltFilled20, InformationFilled20, InformationSquareFilled20 } from '@carbon/icons-react';
import Button from '../../Button';
import useIsomorphicEffect from '../../../internal/useIsomorphicEffect';
import { useNoInteractiveChildren } from '../../../internal/useNoInteractiveChildren';
import { keys, matches } from '../../../internal/keyboard';
var prefix = settings.prefix;
/**
 * Conditionally call a callback when the escape key is pressed
 * @param {node} ref - ref of the container element to scope the functionality to
 * @param {func} callback - function to be called
 * @param {bool} override - escape hatch to conditionally call the callback
 */

function useEscapeToClose(ref, callback) {
  var override = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : true;

  var handleKeyDown = function handleKeyDown(event) {
    // The callback should only be called when focus is on or within the container
    var elementContainsFocus = ref.current && document.activeElement === ref.current || ref.current.contains(document.activeElement);

    if (matches(event, [keys.Escape]) && override && elementContainsFocus) {
      callback(event);
    }
  };

  useIsomorphicEffect(function () {
    document.addEventListener('keydown', handleKeyDown, false);
    return function () {
      return document.removeEventListener('keydown', handleKeyDown, false);
    };
  });
}

export function NotificationActionButton(_ref) {
  var children = _ref.children,
      customClassName = _ref.className,
      onClick = _ref.onClick,
      inline = _ref.inline,
      rest = _objectWithoutProperties(_ref, _excluded);

  var className = cx(customClassName, _defineProperty({}, "".concat(prefix, "--actionable-notification__action-button"), true));
  return /*#__PURE__*/React.createElement(Button, _extends({
    className: className,
    kind: inline ? 'ghost' : 'tertiary',
    onClick: onClick,
    size: "sm"
  }, rest), children);
}
NotificationActionButton.propTypes = {
  /**
   * Specify the content of the notification action button.
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the notification action button
   */
  className: PropTypes.string,

  /**
   * Specify if the visual treatment of the button should be for an inline notification
   */
  inline: PropTypes.bool,

  /**
   * Optionally specify a click handler for the notification action button.
   */
  onClick: PropTypes.func
};
export function NotificationButton(_ref2) {
  var ariaLabel = _ref2.ariaLabel,
      className = _ref2.className,
      iconDescription = _ref2.iconDescription,
      type = _ref2.type,
      IconTag = _ref2.renderIcon,
      name = _ref2.name,
      notificationType = _ref2.notificationType,
      rest = _objectWithoutProperties(_ref2, _excluded2);

  var buttonClassName = cx(className, _defineProperty({}, "".concat(prefix, "--").concat(notificationType, "-notification__close-button"), notificationType));
  var iconClassName = cx(_defineProperty({}, "".concat(prefix, "--").concat(notificationType, "-notification__close-icon"), notificationType));
  return /*#__PURE__*/React.createElement("button", _extends({}, rest, {
    // eslint-disable-next-line react/button-has-type
    type: type,
    "aria-label": iconDescription,
    title: iconDescription,
    className: buttonClassName
  }), IconTag && /*#__PURE__*/React.createElement(IconTag, {
    "aria-label": ariaLabel,
    className: iconClassName,
    name: name
  }));
}
NotificationButton.propTypes = {
  /**
   * Specify a label to be read by screen readers on the notification button
   */
  ariaLabel: PropTypes.string,

  /**
   * Specify an optional className to be applied to the notification button
   */
  className: PropTypes.string,

  /**
   * Provide a description for "close" icon that can be read by screen readers
   */
  iconDescription: PropTypes.string,

  /**
   * Specify an optional icon for the Button through a string,
   * if something but regular "close" icon is desirable
   */
  name: PropTypes.string,

  /**
   * Specify the notification type
   */
  notificationType: PropTypes.oneOf(['toast', 'inline', 'actionable']),

  /**
   * Optional prop to allow overriding the icon rendering.
   * Can be a React component class
   */
  renderIcon: PropTypes.oneOfType([PropTypes.func, PropTypes.object]),

  /**
   * Optional prop to specify the type of the Button
   */
  type: PropTypes.string
};
NotificationButton.defaultProps = {
  ariaLabel: 'close notification',
  // TODO: deprecate this prop
  notificationType: 'toast',
  type: 'button',
  iconDescription: 'close icon',
  renderIcon: Close20
};
var iconTypes = (_iconTypes = {
  error: ErrorFilled20,
  success: CheckmarkFilled20,
  warning: WarningFilled20
}, _defineProperty(_iconTypes, 'warning-alt', WarningAltFilled20), _defineProperty(_iconTypes, "info", InformationFilled20), _defineProperty(_iconTypes, 'info-square', InformationSquareFilled20), _iconTypes);

function NotificationIcon(_ref3) {
  var iconDescription = _ref3.iconDescription,
      kind = _ref3.kind,
      notificationType = _ref3.notificationType;
  var IconForKind = iconTypes[kind];

  if (!IconForKind) {
    return null;
  }

  return /*#__PURE__*/React.createElement(IconForKind, {
    className: "".concat(prefix, "--").concat(notificationType, "-notification__icon")
  }, /*#__PURE__*/React.createElement("title", null, iconDescription));
}

NotificationIcon.propTypes = {
  iconDescription: PropTypes.string.isRequired,
  kind: PropTypes.oneOf(['error', 'success', 'warning', 'warning-alt', 'info', 'info-square']).isRequired,
  notificationType: PropTypes.oneOf(['inline', 'toast']).isRequired
};
export function ToastNotification(_ref4) {
  var _cx4;

  var role = _ref4.role,
      onClose = _ref4.onClose,
      onCloseButtonClick = _ref4.onCloseButtonClick,
      iconDescription = _ref4.iconDescription,
      statusIconDescription = _ref4.statusIconDescription,
      className = _ref4.className,
      children = _ref4.children,
      kind = _ref4.kind,
      lowContrast = _ref4.lowContrast,
      hideCloseButton = _ref4.hideCloseButton,
      timeout = _ref4.timeout,
      closeOnEscape = _ref4.closeOnEscape,
      rest = _objectWithoutProperties(_ref4, _excluded3);

  var _useState = useState(true),
      _useState2 = _slicedToArray(_useState, 2),
      isOpen = _useState2[0],
      setIsOpen = _useState2[1];

  var containerClassName = cx(className, (_cx4 = {}, _defineProperty(_cx4, "".concat(prefix, "--toast-notification"), true), _defineProperty(_cx4, "".concat(prefix, "--toast-notification--low-contrast"), lowContrast), _defineProperty(_cx4, "".concat(prefix, "--toast-notification--").concat(kind), kind), _cx4));
  var contentRef = useRef(null);
  useNoInteractiveChildren(contentRef);

  var handleClose = function handleClose(evt) {
    if (!onClose || onClose(evt) !== false) {
      setIsOpen(false);
    }
  };

  var ref = useRef(null);
  useEscapeToClose(ref, handleCloseButtonClick, closeOnEscape);

  function handleCloseButtonClick(event) {
    onCloseButtonClick(event);
    handleClose(event);
  }

  var savedOnClose = useRef(onClose);
  useEffect(function () {
    savedOnClose.current = onClose;
  });
  useEffect(function () {
    if (!timeout) {
      return;
    }

    var timeoutId = window.setTimeout(function (event) {
      setIsOpen(false);

      if (savedOnClose.current) {
        savedOnClose.current(event);
      }
    }, timeout);
    return function () {
      window.clearTimeout(timeoutId);
    };
  }, [timeout]);

  if (!isOpen) {
    return null;
  }

  return /*#__PURE__*/React.createElement("div", _extends({
    ref: ref
  }, rest, {
    role: role,
    className: containerClassName
  }), /*#__PURE__*/React.createElement(NotificationIcon, {
    notificationType: "toast",
    kind: kind,
    iconDescription: statusIconDescription || "".concat(kind, " icon")
  }), /*#__PURE__*/React.createElement("div", {
    ref: contentRef,
    className: "".concat(prefix, "--toast-notification__content")
  }, children), !hideCloseButton && /*#__PURE__*/React.createElement(NotificationButton, {
    iconDescription: iconDescription,
    notificationType: "toast",
    onClick: handleCloseButtonClick,
    "aria-hidden": "true"
  }));
}
ToastNotification.propTypes = {
  /**
   * Specify the content
   */
  children: PropTypes.node.isRequired,

  /**
   * Specify an optional className to be applied to the notification box
   */
  className: PropTypes.string,

  /**
   * Specify if pressing the escape key should close notifications
   */
  closeOnEscape: PropTypes.bool,

  /**
   * Specify the close button should be disabled, or not
   */
  hideCloseButton: PropTypes.bool,

  /**
   * Provide a description for "close" icon that can be read by screen readers
   */
  iconDescription: PropTypes.string,

  /**
   * Specify what state the notification represents
   */
  kind: PropTypes.oneOf(['error', 'info', 'info-square', 'success', 'warning', 'warning-alt']).isRequired,

  /**
   * Specify whether you are using the low contrast variant of the ToastNotification.
   */
  lowContrast: PropTypes.bool,

  /**
   * Provide a function that is called when menu is closed
   */
  onClose: PropTypes.func,

  /**
   * Provide a function that is called when the close button is clicked
   */
  onCloseButtonClick: PropTypes.func,

  /**
   * By default, this value is "alert". You can also provide an alternate
   * role if it makes sense from the accessibility-side
   */
  role: PropTypes.oneOf(['alert', 'log', 'status']).isRequired,

  /**
   * Provide a description for "status" icon that can be read by screen readers
   */
  statusIconDescription: PropTypes.string,

  /**
   * Specify an optional duration the notification should be closed in
   */
  timeout: PropTypes.number
};
ToastNotification.defaultProps = {
  kind: 'error',
  children: 'provide content',
  role: 'status',
  iconDescription: 'closes notification',
  onCloseButtonClick: function onCloseButtonClick() {},
  hideCloseButton: false,
  timeout: 0,
  closeOnEscape: true
};
export function InlineNotification(_ref5) {
  var _cx5;

  var children = _ref5.children,
      role = _ref5.role,
      onClose = _ref5.onClose,
      onCloseButtonClick = _ref5.onCloseButtonClick,
      iconDescription = _ref5.iconDescription,
      statusIconDescription = _ref5.statusIconDescription,
      className = _ref5.className,
      kind = _ref5.kind,
      lowContrast = _ref5.lowContrast,
      hideCloseButton = _ref5.hideCloseButton,
      closeOnEscape = _ref5.closeOnEscape,
      rest = _objectWithoutProperties(_ref5, _excluded4);

  var _useState3 = useState(true),
      _useState4 = _slicedToArray(_useState3, 2),
      isOpen = _useState4[0],
      setIsOpen = _useState4[1];

  var containerClassName = cx(className, (_cx5 = {}, _defineProperty(_cx5, "".concat(prefix, "--inline-notification"), true), _defineProperty(_cx5, "".concat(prefix, "--inline-notification--low-contrast"), lowContrast), _defineProperty(_cx5, "".concat(prefix, "--inline-notification--").concat(kind), kind), _defineProperty(_cx5, "".concat(prefix, "--inline-notification--hide-close-button"), hideCloseButton), _cx5));
  var contentRef = useRef(null);
  useNoInteractiveChildren(contentRef);

  var handleClose = function handleClose(evt) {
    if (!onClose || onClose(evt) !== false) {
      setIsOpen(false);
    }
  };

  var ref = useRef(null);
  useEscapeToClose(ref, handleCloseButtonClick, closeOnEscape);

  function handleCloseButtonClick(event) {
    onCloseButtonClick(event);
    handleClose(event);
  }

  if (!isOpen) {
    return null;
  }

  return /*#__PURE__*/React.createElement("div", _extends({
    ref: ref
  }, rest, {
    role: role,
    className: containerClassName
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--inline-notification__details")
  }, /*#__PURE__*/React.createElement(NotificationIcon, {
    notificationType: "inline",
    kind: kind,
    iconDescription: statusIconDescription || "".concat(kind, " icon")
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--inline-notification__text-wrapper")
  }, /*#__PURE__*/React.createElement("div", {
    ref: contentRef,
    className: "".concat(prefix, "--inline-notification__content")
  }, children))), !hideCloseButton && /*#__PURE__*/React.createElement(NotificationButton, {
    iconDescription: iconDescription,
    notificationType: "inline",
    onClick: handleCloseButtonClick,
    "aria-hidden": true
  }));
}
InlineNotification.propTypes = {
  /**
   * Specify the content
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the notification box
   */
  className: PropTypes.string,

  /**
   * Specify if pressing the escape key should close notifications
   */
  closeOnEscape: PropTypes.bool,

  /**
   * Specify the close button should be disabled, or not
   */
  hideCloseButton: PropTypes.bool,

  /**
   * Provide a description for "close" icon that can be read by screen readers
   */
  iconDescription: PropTypes.string,

  /**
   * Specify what state the notification represents
   */
  kind: PropTypes.oneOf(['error', 'info', 'info-square', 'success', 'warning', 'warning-alt']).isRequired,

  /**
   * Specify whether you are using the low contrast variant of the InlineNotification.
   */
  lowContrast: PropTypes.bool,

  /**
   * Provide a function that is called when menu is closed
   */
  onClose: PropTypes.func,

  /**
   * Provide a function that is called when the close button is clicked
   */
  onCloseButtonClick: PropTypes.func,

  /**
   * By default, this value is "alert". You can also provide an alternate
   * role if it makes sense from the accessibility-side. If the `actions` prop is
   * configured, this will be overridden to "alertdialog".
   */
  role: PropTypes.oneOf(['alert', 'log', 'status']).isRequired,

  /**
   * Provide a description for "status" icon that can be read by screen readers
   */
  statusIconDescription: PropTypes.string
};
InlineNotification.defaultProps = {
  kind: 'error',
  children: 'provide content',
  role: 'status',
  iconDescription: 'closes notification',
  onCloseButtonClick: function onCloseButtonClick() {},
  hideCloseButton: false,
  closeOnEscape: true
};
export function ActionableNotification(_ref6) {
  var _cx6;

  var actionButtonLabel = _ref6.actionButtonLabel,
      children = _ref6.children,
      role = _ref6.role,
      onActionButtonClick = _ref6.onActionButtonClick,
      onClose = _ref6.onClose,
      onCloseButtonClick = _ref6.onCloseButtonClick,
      iconDescription = _ref6.iconDescription,
      statusIconDescription = _ref6.statusIconDescription,
      className = _ref6.className,
      inline = _ref6.inline,
      kind = _ref6.kind,
      lowContrast = _ref6.lowContrast,
      hideCloseButton = _ref6.hideCloseButton,
      hasFocus = _ref6.hasFocus,
      closeOnEscape = _ref6.closeOnEscape,
      rest = _objectWithoutProperties(_ref6, _excluded5);

  var _useState5 = useState(true),
      _useState6 = _slicedToArray(_useState5, 2),
      isOpen = _useState6[0],
      setIsOpen = _useState6[1];

  var containerClassName = cx(className, (_cx6 = {}, _defineProperty(_cx6, "".concat(prefix, "--actionable-notification"), true), _defineProperty(_cx6, "".concat(prefix, "--actionable-notification--toast"), !inline), _defineProperty(_cx6, "".concat(prefix, "--actionable-notification--low-contrast"), lowContrast), _defineProperty(_cx6, "".concat(prefix, "--actionable-notification--").concat(kind), kind), _defineProperty(_cx6, "".concat(prefix, "--actionable-notification--hide-close-button"), hideCloseButton), _cx6));
  var ref = useRef(null);
  useIsomorphicEffect(function () {
    if (ref.current && hasFocus) {
      ref.current.focus();
    }
  });

  var handleClose = function handleClose(evt) {
    if (!onClose || onClose(evt) !== false) {
      setIsOpen(false);
    }
  };

  useEscapeToClose(ref, handleCloseButtonClick, closeOnEscape);

  function handleCloseButtonClick(event) {
    onCloseButtonClick(event);
    handleClose(event);
  }

  if (!isOpen) {
    return null;
  }

  return /*#__PURE__*/React.createElement("div", _extends({}, rest, {
    ref: ref,
    role: role,
    className: containerClassName
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--actionable-notification__details")
  }, /*#__PURE__*/React.createElement(NotificationIcon, {
    notificationType: inline ? 'inline' : 'toast',
    kind: kind,
    iconDescription: statusIconDescription || "".concat(kind, " icon")
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--actionable-notification__text-wrapper")
  }, /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--actionable-notification__content")
  }, children))), /*#__PURE__*/React.createElement(NotificationActionButton, {
    onClick: onActionButtonClick,
    inline: inline
  }, actionButtonLabel), !hideCloseButton && /*#__PURE__*/React.createElement(NotificationButton, {
    iconDescription: iconDescription,
    notificationType: "actionable",
    onClick: handleCloseButtonClick,
    "aria-hidden": true
  }));
}
ActionableNotification.propTypes = {
  /**
   * Pass in the action button label that will be rendered within the ActionableNotification.
   */
  actionButtonLabel: PropTypes.string.isRequired,

  /**
   * Specify the content
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the notification box
   */
  className: PropTypes.string,

  /**
   * Specify if pressing the escape key should close notifications
   */
  closeOnEscape: PropTypes.bool,

  /**
   * Specify if focus should be moved to the component when the notification contains actions
   */
  hasFocus: PropTypes.bool,

  /**
   * Specify the close button should be disabled, or not
   */
  hideCloseButton: PropTypes.bool,

  /**
   * Provide a description for "close" icon that can be read by screen readers
   */
  iconDescription: PropTypes.string,

  /*
   * Specify if the notification should have inline styling applied instead of toast
   */
  inline: PropTypes.bool,

  /**
   * Specify what state the notification represents
   */
  kind: PropTypes.oneOf(['error', 'info', 'info-square', 'success', 'warning', 'warning-alt']).isRequired,

  /**
   * Specify whether you are using the low contrast variant of the ActionableNotification.
   */
  lowContrast: PropTypes.bool,

  /**
   * Provide a function that is called when the action is clicked
   */
  onActionButtonClick: PropTypes.func,

  /**
   * Provide a function that is called when menu is closed
   */
  onClose: PropTypes.func,

  /**
   * Provide a function that is called when the close button is clicked
   */
  onCloseButtonClick: PropTypes.func,

  /**
   * By default, this value is "alertdialog". You can also provide an alternate
   * role if it makes sense from the accessibility-side.
   */
  role: PropTypes.string,

  /**
   * Provide a description for "status" icon that can be read by screen readers
   */
  statusIconDescription: PropTypes.string
};
ActionableNotification.defaultProps = {
  kind: 'error',
  children: 'provide content',
  role: 'alertdialog',
  iconDescription: 'closes notification',
  onCloseButtonClick: function onCloseButtonClick() {},
  hideCloseButton: false,
  hasFocus: true,
  closeOnEscape: true,
  inline: false
};