import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";

var _Modal$propTypes;

var _excluded = ["children", "className", "modalHeading", "modalLabel", "modalAriaLabel", "passiveModal", "hasForm", "secondaryButtonText", "primaryButtonText", "open", "onRequestClose", "onRequestSubmit", "onSecondarySubmit", "iconDescription", "primaryButtonDisabled", "danger", "alert", "secondaryButtons", "selectorPrimaryFocus", "selectorsFloatingMenus", "shouldSubmitOnEnter", "size", "hasScrollingContent", "closeButtonLabel", "preventCloseOnClickOutside"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React, { useRef, useEffect } from 'react';
import classNames from 'classnames';
import { Close20 } from '@carbon/icons-react';
import toggleClass from '../../../tools/toggleClass';
import Button from '../../Button';
import ButtonSet from '../../ButtonSet';
import deprecate from '../../../prop-types/deprecate';
import requiredIfGivenPropIsTruthy from '../../../prop-types/requiredIfGivenPropIsTruthy';
import wrapFocus, { elementOrParentIsFloatingMenu } from '../../../internal/wrapFocus';
import setupGetInstanceId from '../../../tools/setupGetInstanceId';
import { usePrefix } from '../../../internal/usePrefix';
var getInstanceId = setupGetInstanceId();
var Modal = /*#__PURE__*/React.forwardRef(function Modal(_ref, ref) {
  var _classNames, _classNames3;

  var children = _ref.children,
      className = _ref.className,
      modalHeading = _ref.modalHeading,
      modalLabel = _ref.modalLabel,
      modalAriaLabel = _ref.modalAriaLabel,
      passiveModal = _ref.passiveModal,
      hasForm = _ref.hasForm,
      secondaryButtonText = _ref.secondaryButtonText,
      primaryButtonText = _ref.primaryButtonText,
      open = _ref.open,
      onRequestClose = _ref.onRequestClose,
      onRequestSubmit = _ref.onRequestSubmit,
      onSecondarySubmit = _ref.onSecondarySubmit,
      iconDescription = _ref.iconDescription,
      primaryButtonDisabled = _ref.primaryButtonDisabled,
      danger = _ref.danger,
      alert = _ref.alert,
      secondaryButtons = _ref.secondaryButtons,
      selectorPrimaryFocus = _ref.selectorPrimaryFocus,
      selectorsFloatingMenus = _ref.selectorsFloatingMenus,
      shouldSubmitOnEnter = _ref.shouldSubmitOnEnter,
      size = _ref.size,
      hasScrollingContent = _ref.hasScrollingContent,
      closeButtonLabel = _ref.closeButtonLabel,
      preventCloseOnClickOutside = _ref.preventCloseOnClickOutside,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var button = useRef();
  var secondaryButton = useRef();
  var innerModal = useRef();
  var startTrap = useRef();
  var endTrap = useRef();
  var modalInstanceId = "modal-".concat(getInstanceId());
  var modalLabelId = "".concat(prefix, "--modal-header__label--").concat(modalInstanceId);
  var modalHeadingId = "".concat(prefix, "--modal-header__heading--").concat(modalInstanceId);
  var modalBodyId = "".concat(prefix, "--modal-body--").concat(modalInstanceId);
  var modalCloseButtonClass = "".concat(prefix, "--modal-close");

  function isCloseButton(element) {
    return !onSecondarySubmit && element === secondaryButton.current || element.classList.contains(modalCloseButtonClass);
  }

  function handleKeyDown(evt) {
    if (open) {
      if (evt.which === 27) {
        onRequestClose(evt);
      }

      if (evt.which === 13 && shouldSubmitOnEnter && !isCloseButton(evt.target)) {
        onRequestSubmit(evt);
      }
    }
  }

  function handleMousedown(evt) {
    if (innerModal.current && !innerModal.current.contains(evt.target) && !elementOrParentIsFloatingMenu(evt.target, selectorsFloatingMenus) && !preventCloseOnClickOutside) {
      onRequestClose(evt);
    }
  }

  function handleBlur(_ref2) {
    var oldActiveNode = _ref2.target,
        currentActiveNode = _ref2.relatedTarget;

    if (open && currentActiveNode && oldActiveNode) {
      var bodyNode = innerModal.current;
      var startTrapNode = startTrap.current;
      var endTrapNode = endTrap.current;
      wrapFocus({
        bodyNode: bodyNode,
        startTrapNode: startTrapNode,
        endTrapNode: endTrapNode,
        currentActiveNode: currentActiveNode,
        oldActiveNode: oldActiveNode,
        selectorsFloatingMenus: selectorsFloatingMenus
      });
    }
  }

  var onSecondaryButtonClick = onSecondarySubmit ? onSecondarySubmit : onRequestClose;
  var modalClasses = classNames("".concat(prefix, "--modal"), (_classNames = {}, _defineProperty(_classNames, "".concat(prefix, "--modal-tall"), !passiveModal), _defineProperty(_classNames, 'is-visible', open), _defineProperty(_classNames, "".concat(prefix, "--modal--danger"), danger), _defineProperty(_classNames, className, className), _classNames));
  var containerClasses = classNames("".concat(prefix, "--modal-container"), _defineProperty({}, "".concat(prefix, "--modal-container--").concat(size), size));
  var contentClasses = classNames("".concat(prefix, "--modal-content"), (_classNames3 = {}, _defineProperty(_classNames3, "".concat(prefix, "--modal-content--with-form"), hasForm), _defineProperty(_classNames3, "".concat(prefix, "--modal-scroll-content"), hasScrollingContent), _classNames3));
  var footerClasses = classNames("".concat(prefix, "--modal-footer"), _defineProperty({}, "".concat(prefix, "--modal-footer--three-button"), Array.isArray(secondaryButtons) && secondaryButtons.length === 2));
  var modalButton = /*#__PURE__*/React.createElement("button", {
    className: modalCloseButtonClass,
    type: "button",
    onClick: onRequestClose,
    title: ariaLabel ? ariaLabel : iconDescription,
    "aria-label": closeButtonLabel ? closeButtonLabel : 'close',
    ref: button
  }, /*#__PURE__*/React.createElement(Close20, {
    "aria-hidden": "true",
    tabIndex: "-1",
    className: "".concat(modalCloseButtonClass, "__icon")
  }));
  var ariaLabel = modalLabel || ['aria-label'] || modalAriaLabel || modalHeading;
  var getAriaLabelledBy = modalLabel ? modalLabelId : modalHeadingId;
  var hasScrollingContentProps = hasScrollingContent ? {
    tabIndex: 0,
    role: 'region',
    'aria-label': ariaLabel,
    'aria-labelledby': getAriaLabelledBy
  } : {};
  var alertDialogProps = {};

  if (alert && passiveModal) {
    alertDialogProps.role = 'alert';
  }

  if (alert && !passiveModal) {
    alertDialogProps.role = 'alertdialog';
    alertDialogProps['aria-describedby'] = modalBodyId;
  }

  useEffect(function () {
    return function () {
      toggleClass(document.body, "".concat(prefix, "--body--with-modal-open"), false);
    };
  }, [prefix]);
  useEffect(function () {
    toggleClass(document.body, "".concat(prefix, "--body--with-modal-open"), open);
  }, [open, prefix]);
  useEffect(function () {
    var initialFocus = function initialFocus(focusContainerElement) {
      var containerElement = focusContainerElement || innerModal.current;
      var primaryFocusElement = containerElement ? containerElement.querySelector(selectorPrimaryFocus) : null;

      if (primaryFocusElement) {
        return primaryFocusElement;
      }

      return button && button.current;
    };

    var focusButton = function focusButton(focusContainerElement) {
      var target = initialFocus(focusContainerElement);

      if (target) {
        target.focus();
      }
    };

    if (open) {
      focusButton(innerModal.current);
    }
  }, [open, selectorPrimaryFocus]);
  var modalBody = /*#__PURE__*/React.createElement("div", _extends({
    ref: innerModal,
    role: "dialog"
  }, alertDialogProps, {
    className: containerClasses,
    "aria-label": ariaLabel,
    "aria-modal": "true",
    tabIndex: "-1"
  }), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--modal-header")
  }, passiveModal && modalButton, modalLabel && /*#__PURE__*/React.createElement("h2", {
    id: modalLabelId,
    className: "".concat(prefix, "--modal-header__label")
  }, modalLabel), /*#__PURE__*/React.createElement("h3", {
    id: modalHeadingId,
    className: "".concat(prefix, "--modal-header__heading")
  }, modalHeading), !passiveModal && modalButton), /*#__PURE__*/React.createElement("div", _extends({
    id: modalBodyId,
    className: contentClasses
  }, hasScrollingContentProps, {
    "aria-labelledby": getAriaLabelledBy
  }), children), hasScrollingContent && /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--modal-content--overflow-indicator")
  }), !passiveModal && /*#__PURE__*/React.createElement(ButtonSet, {
    className: footerClasses
  }, Array.isArray(secondaryButtons) && secondaryButtons.length <= 2 ? secondaryButtons.map(function (_ref3, i) {
    var buttonText = _ref3.buttonText,
        onButtonClick = _ref3.onClick;
    return /*#__PURE__*/React.createElement(Button, {
      key: "".concat(buttonText, "-").concat(i),
      kind: "secondary",
      onClick: onButtonClick
    }, buttonText);
  }) : secondaryButtonText && /*#__PURE__*/React.createElement(Button, {
    kind: "secondary",
    onClick: onSecondaryButtonClick,
    ref: secondaryButton
  }, secondaryButtonText), /*#__PURE__*/React.createElement(Button, {
    kind: danger ? 'danger' : 'primary',
    disabled: primaryButtonDisabled,
    onClick: onRequestSubmit,
    ref: button
  }, primaryButtonText)));
  return /*#__PURE__*/React.createElement("div", _extends({}, rest, {
    onKeyDown: handleKeyDown,
    onMouseDown: handleMousedown,
    onBlur: handleBlur,
    className: modalClasses,
    role: "presentation",
    ref: ref
  }), /*#__PURE__*/React.createElement("span", {
    ref: startTrap,
    tabIndex: "0",
    role: "link",
    className: "".concat(prefix, "--visually-hidden")
  }, "Focus sentinel"), modalBody, /*#__PURE__*/React.createElement("span", {
    ref: endTrap,
    tabIndex: "0",
    role: "link",
    className: "".concat(prefix, "--visually-hidden")
  }, "Focus sentinel"));
});
Modal.propTypes = (_Modal$propTypes = {
  /**
   * Specify whether the Modal is displaying an alert, error or warning
   * Should go hand in hand with the danger prop.
   */
  alert: PropTypes.bool
}, _defineProperty(_Modal$propTypes, 'aria-label', requiredIfGivenPropIsTruthy('hasScrollingContent', PropTypes.string)), _defineProperty(_Modal$propTypes, "children", PropTypes.node), _defineProperty(_Modal$propTypes, "className", PropTypes.string), _defineProperty(_Modal$propTypes, "closeButtonLabel", PropTypes.string), _defineProperty(_Modal$propTypes, "danger", PropTypes.bool), _defineProperty(_Modal$propTypes, "focusTrap", deprecate(PropTypes.bool, "\nThe prop `focusTrap` for Modal has been deprecated, as the feature of `focusTrap` runs by default.")), _defineProperty(_Modal$propTypes, "hasForm", deprecate(PropTypes.bool, "\nThe prop `hasForm` for Modal has been deprecated, as the feature of `hasForm` runs by default.")), _defineProperty(_Modal$propTypes, "hasScrollingContent", PropTypes.bool), _defineProperty(_Modal$propTypes, "iconDescription", deprecate(PropTypes.string, 'The iconDescription prop is no longer needed and can be safely removed. This prop will be removed in the next major release of Carbon.')), _defineProperty(_Modal$propTypes, "id", PropTypes.string), _defineProperty(_Modal$propTypes, "modalAriaLabel", PropTypes.string), _defineProperty(_Modal$propTypes, "modalHeading", PropTypes.node), _defineProperty(_Modal$propTypes, "modalLabel", PropTypes.node), _defineProperty(_Modal$propTypes, "onKeyDown", PropTypes.func), _defineProperty(_Modal$propTypes, "onRequestClose", PropTypes.func), _defineProperty(_Modal$propTypes, "onRequestSubmit", PropTypes.func), _defineProperty(_Modal$propTypes, "onSecondarySubmit", PropTypes.func), _defineProperty(_Modal$propTypes, "open", PropTypes.bool), _defineProperty(_Modal$propTypes, "passiveModal", PropTypes.bool), _defineProperty(_Modal$propTypes, "preventCloseOnClickOutside", PropTypes.bool), _defineProperty(_Modal$propTypes, "primaryButtonDisabled", PropTypes.bool), _defineProperty(_Modal$propTypes, "primaryButtonText", PropTypes.node), _defineProperty(_Modal$propTypes, "secondaryButtonText", PropTypes.node), _defineProperty(_Modal$propTypes, "secondaryButtons", function secondaryButtons(props, propName, componentName) {
  if (props.secondaryButtons) {
    if (!Array.isArray(props.secondaryButtons) || props.secondaryButtons.length !== 2) {
      return new Error("".concat(propName, " needs to be an array of two button config objects"));
    }

    var shape = {
      buttonText: PropTypes.node,
      onClick: PropTypes.func
    };
    props[propName].forEach(function (secondaryButton) {
      PropTypes.checkPropTypes(shape, secondaryButton, propName, componentName);
    });
  }

  return null;
}), _defineProperty(_Modal$propTypes, "selectorPrimaryFocus", PropTypes.string), _defineProperty(_Modal$propTypes, "selectorsFloatingMenus", PropTypes.arrayOf(PropTypes.string)), _defineProperty(_Modal$propTypes, "shouldSubmitOnEnter", PropTypes.bool), _defineProperty(_Modal$propTypes, "size", PropTypes.oneOf(['xs', 'sm', 'md', 'lg'])), _Modal$propTypes);
Modal.defaultProps = {
  onRequestClose: function onRequestClose() {},
  onRequestSubmit: function onRequestSubmit() {},
  primaryButtonDisabled: false,
  onKeyDown: function onKeyDown() {},
  passiveModal: false,
  modalHeading: '',
  modalLabel: '',
  preventCloseOnClickOutside: false,
  selectorPrimaryFocus: '[data-modal-primary-focus]',
  hasScrollingContent: false
};
export default Modal;