import _typeof from "@babel/runtime/helpers/typeof";
import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _regeneratorRuntime from "@babel/runtime/regenerator";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import Loading from '../Loading';
import { mount } from 'enzyme';
import { settings } from 'carbon-components';
import { render, cleanup } from '@carbon/test-utils/react';
import { afterEach } from 'jest-circus';
var prefix = settings.prefix;
describe('Loading', function () {
  afterEach(cleanup);
  describe('automated accessibility testing', function () {
    it('should have no Axe violations', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee() {
      var _render, container;

      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _render = render( /*#__PURE__*/React.createElement(Loading, null)), container = _render.container;
              _context.next = 3;
              return expect(container).toHaveNoAxeViolations();

            case 3:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    })));
    it('should have no AC violations', /*#__PURE__*/_asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2() {
      var _render2, container;

      return _regeneratorRuntime.wrap(function _callee2$(_context2) {
        while (1) {
          switch (_context2.prev = _context2.next) {
            case 0:
              _render2 = render( /*#__PURE__*/React.createElement(Loading, null)), container = _render2.container;
              _context2.next = 3;
              return expect(container).toHaveNoACViolations('Loading');

            case 3:
            case "end":
              return _context2.stop();
          }
        }
      }, _callee2);
    })));
  });
  describe('with a screenreader', function () {
    afterEach(cleanup); // https://www.w3.org/TR/WCAG21/#headings-and-labels

    it('should have a label on the live region', function () {
      var _render3 = render( /*#__PURE__*/React.createElement(Loading, null)),
          container = _render3.container;

      var liveRegion = container.querySelector('[aria-live]');
      expect(liveRegion).toBeInstanceOf(HTMLElement);
      var id = liveRegion.getAttribute('aria-labelledby');
      expect(id).toBeDefined();
      var label = document.getElementById(id);
      expect(label).toBeDefined();
      expect(_typeof(label.textContent)).toBe('string');
    }); // https://www.w3.org/TR/WCAG21/#status-messages

    it('should announce a loading status', function () {
      var _render4 = render( /*#__PURE__*/React.createElement(Loading, null)),
          container = _render4.container;

      var liveRegion = container.querySelector('[aria-live]');
      expect(liveRegion).toBeInstanceOf(HTMLElement);
      var atomicBoolean = liveRegion.getAttribute('aria-atomic');
      expect(atomicBoolean).toBe('true');
      var ariaLiveValue = liveRegion.getAttribute('aria-live');
      expect(ariaLiveValue).toEqual('assertive');
    });
  });
  describe('renders as expected', function () {
    var wrapper = mount( /*#__PURE__*/React.createElement(Loading, {
      className: "extra-class"
    }));
    var overlay = wrapper.find(".".concat(prefix, "--loading-overlay"));
    var loader = wrapper.find(".".concat(prefix, "--loading"));
    var svg = loader.find('svg');
    it('should render with an overlay', function () {
      expect(overlay.length).toEqual(1);
    });
    it('should render with a loader', function () {
      expect(loader.length).toEqual(1);
    });
    it('should render an svg', function () {
      expect(svg.length).toEqual(1);
    });
    it('overlay has the expected class', function () {
      expect(overlay.hasClass("".concat(prefix, "--loading-overlay"))).toEqual(true);
    });
    it('loader has the expected classes', function () {
      expect(loader.hasClass("".concat(prefix, "--loading"))).toEqual(true);
    });
    it('svg has the correct class', function () {
      expect(svg.hasClass("".concat(prefix, "--loading__svg"))).toEqual(true);
    });
    it('should add extra classes that are passed via className', function () {
      expect(loader.hasClass('extra-class')).toEqual(true);
    });
  });
  describe('sets props and state as expected', function () {
    var wrapper = mount( /*#__PURE__*/React.createElement(Loading, {
      className: "extra-class"
    }));
    it("should remove and add ".concat(prefix, "--loading--stop class"), function () {
      wrapper.setProps({
        active: false
      });
      expect(wrapper.find(".".concat(prefix, "--loading")).hasClass("".concat(prefix, "--loading--stop"))).toEqual(true);
      wrapper.setProps({
        active: true
      });
      expect(wrapper.find(".".concat(prefix, "--loading")).hasClass("".concat(prefix, "--loading--stop"))).toEqual(false);
    });
    it('should not render overlay when withOverlay is set to false', function () {
      wrapper.setProps({
        withOverlay: false
      });
      var overlay = wrapper.find(".".concat(prefix, "--loading-overlay"));
      expect(overlay.length).toEqual(0);
    });
  });
});