import _extends from "@babel/runtime/helpers/extends";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { withKnobs, boolean, text } from '@storybook/addon-knobs';
import Loading from '../Loading';
import mdx from './Loading.mdx';

var props = function props() {
  return {
    active: boolean('Active (active)', true),
    withOverlay: boolean('With overlay (withOverlay)', false),
    small: boolean('Small (small)', false),
    description: text('Description (description)', 'Active loading indicator')
  };
};

export default {
  title: 'Components/Loading',
  decorators: [withKnobs],
  parameters: {
    component: Loading,
    docs: {
      page: mdx
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(Loading, _extends({}, props(), {
    className: 'some-class'
  }));
};
Default.parameters = {
  info: {
    text: "\n        Loading spinners are used when retrieving data or performing slow computations,\n        and help to notify users that loading is underway. The 'active' property is true by default;\n        set to false to end the animation.\n      "
  }
};