import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";

var _defaultTranslations;

var _excluded = ["clearSelection", "selectionCount", "translateWithId", "disabled", "onClearSelection"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import React from 'react';
import PropTypes from 'prop-types';
import { Close16 } from '@carbon/icons-react';
import { settings } from 'carbon-components';
import { match, keys } from '../../../internal/keyboard';
var prefix = settings.prefix;
/**
 * `ListBoxSelection` is used to provide controls for clearing a selection, in
 * addition to conditionally rendering a badge if the control has more than one
 * selection.
 */

function ListBoxSelection(_ref) {
  var _cx;

  var clearSelection = _ref.clearSelection,
      selectionCount = _ref.selectionCount,
      t = _ref.translateWithId,
      disabled = _ref.disabled,
      onClearSelection = _ref.onClearSelection,
      rest = _objectWithoutProperties(_ref, _excluded);

  var className = cx("".concat(prefix, "--list-box__selection"), (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--tag--filter"), selectionCount), _defineProperty(_cx, "".concat(prefix, "--list-box__selection--multi"), selectionCount), _cx));
  var description = selectionCount ? t('clear.all') : t('clear.selection');
  var tagClasses = cx("".concat(prefix, "--tag"), "".concat(prefix, "--tag--filter"), "".concat(prefix, "--tag--high-contrast"), _defineProperty({}, "".concat(prefix, "--tag--disabled"), disabled));

  function onClick(event) {
    event.stopPropagation();

    if (disabled) {
      return;
    }

    clearSelection(event);

    if (onClearSelection) {
      onClearSelection(event);
    }
  }

  function onKeyDown(event) {
    event.stopPropagation();

    if (disabled) {
      return;
    } // When a user hits ENTER, we'll clear the selection


    if (match(event, keys.Enter)) {
      clearSelection(event);

      if (onClearSelection) {
        onClearSelection(event);
      }
    }
  }

  if (selectionCount) {
    return /*#__PURE__*/React.createElement("div", {
      className: tagClasses
    }, /*#__PURE__*/React.createElement("span", {
      className: "".concat(prefix, "--tag__label"),
      title: selectionCount
    }, selectionCount), /*#__PURE__*/React.createElement("button", {
      "aria-label": description,
      className: "".concat(prefix, "--tag__close-icon"),
      disabled: disabled,
      onClick: onClick,
      onKeyDown: onKeyDown,
      tabIndex: disabled ? -1 : 0,
      title: description,
      type: "button"
    }, /*#__PURE__*/React.createElement(Close16, null)));
  }

  return /*#__PURE__*/React.createElement("button", _extends({}, rest, {
    "aria-label": description,
    className: className,
    onClick: onClick,
    onKeyDown: onKeyDown,
    tabIndex: disabled ? -1 : 0,
    title: description,
    type: "button"
  }), /*#__PURE__*/React.createElement(Close16, null));
}

export var translationIds = {
  'clear.all': 'clear.all',
  'clear.selection': 'clear.selection'
};
var defaultTranslations = (_defaultTranslations = {}, _defineProperty(_defaultTranslations, translationIds['clear.all'], 'Clear all selected items'), _defineProperty(_defaultTranslations, translationIds['clear.selection'], 'Clear selected item'), _defaultTranslations);
ListBoxSelection.propTypes = {
  /**
   * Specify a function to be invoked when a user interacts with the clear
   * selection element.
   */
  clearSelection: PropTypes.func.isRequired,

  /**
   * Specify whether or not the clear selection element should be disabled
   */
  disabled: PropTypes.bool,

  /**
   * Specify an optional `onClearSelection` handler that is called when the underlying
   * element is cleared
   */
  onClearSelection: PropTypes.func,

  /**
   * Specify an optional `onClick` handler that is called when the underlying
   * clear selection element is clicked
   */
  onClick: PropTypes.func,

  /**
   * Specify an optional `onKeyDown` handler that is called when the underlying
   * clear selection element fires a keydown event
   */
  onKeyDown: PropTypes.func,

  /**
   * Specify an optional `selectionCount` value that will be used to determine
   * whether the selection should display a badge or a single clear icon.
   */
  selectionCount: PropTypes.number,

  /**
   * i18n hook used to provide the appropriate description for the given menu
   * icon. This function takes in an id defined in `translationIds` and should
   * return a string message for that given message id.
   */
  translateWithId: PropTypes.func.isRequired
};
ListBoxSelection.defaultProps = {
  translateWithId: function translateWithId(id) {
    return defaultTranslations[id];
  }
};
export default ListBoxSelection;