import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "href", "disabled", "inline", "visited", "renderIcon", "size"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import classnames from 'classnames';
import { usePrefix } from '../../internal/usePrefix';

var Link = function Link(_ref) {
  var _classnames;

  var children = _ref.children,
      className = _ref.className,
      href = _ref.href,
      disabled = _ref.disabled,
      inline = _ref.inline,
      visited = _ref.visited,
      Icon = _ref.renderIcon,
      size = _ref.size,
      other = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var classNames = classnames("".concat(prefix, "--link"), className, (_classnames = {}, _defineProperty(_classnames, "".concat(prefix, "--link--disabled"), disabled), _defineProperty(_classnames, "".concat(prefix, "--link--inline"), inline), _defineProperty(_classnames, "".concat(prefix, "--link--visited"), visited), _defineProperty(_classnames, "".concat(prefix, "--link--").concat(size), size), _classnames));
  var Tag = disabled ? 'p' : 'a';
  var rel = other.target === '_blank' ? 'noopener' : null;
  return /*#__PURE__*/React.createElement(Tag, _extends({
    href: disabled ? null : href,
    className: classNames,
    rel: rel
  }, other), children, !inline && Icon && /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--link__icon")
  }, /*#__PURE__*/React.createElement(Icon, null)));
};

Link.propTypes = {
  /**
   * Provide the content for the Link
   */
  children: PropTypes.node,

  /**
   * Provide a custom className to be applied to the containing `<a>` node
   */
  className: PropTypes.string,

  /**
   * Specify if the control should be disabled, or not
   */
  disabled: PropTypes.bool,

  /**
   * Provide the `href` attribute for the `<a>` node
   */
  href: PropTypes.string,

  /**
   * Specify whether you want the inline version of this control
   */
  inline: PropTypes.bool,

  /**
   * Optional prop to render an icon next to the link.
   * Can be a React component class
   */
  renderIcon: PropTypes.oneOfType([PropTypes.func, PropTypes.object]),

  /**
   * Specify the size of the Link. Currently supports either `sm`, 'md' (default) or 'lg` as an option.
   */
  size: PropTypes.oneOf(['sm', 'md', 'lg']),

  /**
   * Specify whether you want the link to receive visited styles after the link has been clicked
   */
  visited: PropTypes.bool
};
export default Link;