import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["as", "className", "children"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import { usePrefix } from '../../internal/usePrefix';
import { LayerContext } from './LayerContext';
var levels = ['one', 'two', 'three'];
var MAX_LEVEL = levels.length - 1;
export function Layer(_ref) {
  var _ref$as = _ref.as,
      BaseComponent = _ref$as === void 0 ? 'div' : _ref$as,
      customClassName = _ref.className,
      children = _ref.children,
      rest = _objectWithoutProperties(_ref, _excluded);

  var level = React.useContext(LayerContext);
  var prefix = usePrefix();
  var className = cx("".concat(prefix, "--layer-").concat(levels[level]), customClassName);
  return (
    /*#__PURE__*/
    // The level should be between 0 and MAX_LEVEL
    React.createElement(LayerContext.Provider, {
      value: Math.max(0, Math.min(level + 1, MAX_LEVEL))
    }, /*#__PURE__*/React.createElement(BaseComponent, _extends({}, rest, {
      className: className
    }), children))
  );
}
Layer.propTypes = {
  /**
   * Specify a custom component or element to be rendered as the top-level
   * element in the component
   */
  as: PropTypes.oneOfType([PropTypes.func, PropTypes.string, PropTypes.elementType]),

  /**
   * Provide child elements to be rendered inside of `Theme`
   */
  children: PropTypes.node,

  /**
   * Provide a custom class name to be used on the outermost element rendered by
   * the component
   */
  className: PropTypes.string
};