import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "success", "status", "iconDescription", "description", "onSuccess", "successDelay"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import PropTypes from 'prop-types';
import classNames from 'classnames';
import { CheckmarkFilled16, ErrorFilled16 } from '@carbon/icons-react';
import deprecate from '../../prop-types/deprecate';
import Loading from '../Loading';
import { usePrefix } from '../../internal/usePrefix';
export default function InlineLoading(_ref) {
  var className = _ref.className,
      success = _ref.success,
      _ref$status = _ref.status,
      status = _ref$status === void 0 ? success ? 'finished' : 'active' : _ref$status,
      iconDescription = _ref.iconDescription,
      description = _ref.description,
      onSuccess = _ref.onSuccess,
      successDelay = _ref.successDelay,
      other = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var loadingClasses = classNames("".concat(prefix, "--inline-loading"), className);

  var getLoading = function getLoading() {
    if (status === 'error') {
      return /*#__PURE__*/React.createElement(ErrorFilled16, {
        className: "".concat(prefix, "--inline-loading--error")
      }, /*#__PURE__*/React.createElement("title", null, iconDescription));
    }

    if (status === 'finished') {
      setTimeout(function () {
        if (onSuccess) {
          onSuccess();
        }
      }, successDelay);
      return /*#__PURE__*/React.createElement(CheckmarkFilled16, {
        className: "".concat(prefix, "--inline-loading__checkmark-container")
      }, /*#__PURE__*/React.createElement("title", null, iconDescription));
    }

    if (status === 'inactive' || status === 'active') {
      return /*#__PURE__*/React.createElement(Loading, {
        small: true,
        description: iconDescription,
        withOverlay: false,
        active: status === 'active'
      });
    }

    return undefined;
  };

  var loadingText = /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--inline-loading__text")
  }, description);
  var loading = getLoading();
  var loadingAnimation = loading && /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--inline-loading__animation")
  }, loading);
  return /*#__PURE__*/React.createElement("div", _extends({
    className: loadingClasses
  }, other, {
    "aria-live": 'assertive' || other['aria-live']
  }), loadingAnimation, description && loadingText);
}
InlineLoading.propTypes = {
  /**
   * Specify a custom className to be applied to the container node
   */
  className: PropTypes.string,

  /**
   * Specify the description for the inline loading text
   */
  description: PropTypes.node,

  /**
   * Specify the description for the inline loading text
   */
  iconDescription: PropTypes.string,

  /**
   * Provide an optional handler to be invoked when <InlineLoading> is
   * successful
   */
  onSuccess: PropTypes.func,

  /**
   * Specify the loading status
   */
  status: PropTypes.oneOf(['inactive', 'active', 'finished', 'error']),

  /**
   * Specify whether the load was successful
   */
  success: deprecate(PropTypes.bool, "\nThe prop `success` for InlineLoading has been deprecated in favor of `status`. Please use `status=\"finished\"` instead."),

  /**
   * Provide a delay for the `setTimeout` for success
   */
  successDelay: PropTypes.number
};
InlineLoading.defaultProps = {
  successDelay: 1500
};