import './Grid-story.scss';
import React from 'react';
import { Grid, Row, Column } from './';
import mdx from './Grid.mdx';
import { FeatureFlags } from '../FeatureFlags';
import { Heading } from '../Heading';
export default {
  title: 'Components/Grid',
  component: Grid,
  subcomponents: {
    Row: Row,
    Column: Column
  },
  decorators: [function (storyFn) {
    return /*#__PURE__*/React.createElement("div", {
      id: "templates"
    }, storyFn());
  }],
  parameters: {
    docs: {
      page: mdx
    }
  }
};

function DemoContent(_ref) {
  var children = _ref.children;
  return /*#__PURE__*/React.createElement("div", {
    className: "outside"
  }, /*#__PURE__*/React.createElement("div", {
    className: "inside"
  }, children));
}

export var experimentalCSSGrid = function experimentalCSSGrid() {
  return /*#__PURE__*/React.createElement(FeatureFlags, {
    flags: {
      'enable-css-grid': true
    }
  }, /*#__PURE__*/React.createElement(Heading, null, "Wide"), /*#__PURE__*/React.createElement(Grid, null, /*#__PURE__*/React.createElement(Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/React.createElement(Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/React.createElement(Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/React.createElement(Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/React.createElement(Grid, null, /*#__PURE__*/React.createElement(Column, {
    sm: 2,
    md: 4,
    lg: 8
  }, "Subgrid"), /*#__PURE__*/React.createElement(Column, {
    sm: 2,
    md: 4,
    lg: 8
  }, "Subgrid"))), /*#__PURE__*/React.createElement(Heading, null, "Narrow"), /*#__PURE__*/React.createElement(Grid, {
    narrow: true
  }, /*#__PURE__*/React.createElement(Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/React.createElement(Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/React.createElement(Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/React.createElement(Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column")), /*#__PURE__*/React.createElement(Heading, null, "Condensed"), /*#__PURE__*/React.createElement(Grid, {
    condensed: true
  }, /*#__PURE__*/React.createElement(Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/React.createElement(Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/React.createElement(Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column"), /*#__PURE__*/React.createElement(Column, {
    sm: 1,
    md: 2,
    lg: 4
  }, "Column")));
};
export var autoColumns = function autoColumns() {
  return /*#__PURE__*/React.createElement(Grid, null, /*#__PURE__*/React.createElement(Row, null, /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "Span 25%")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "Span 25%")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "Span 25%")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "Span 25%"))));
};
export var responsiveGrid = function responsiveGrid() {
  return /*#__PURE__*/React.createElement(Grid, null, /*#__PURE__*/React.createElement(Row, null, /*#__PURE__*/React.createElement(Column, {
    sm: 2,
    md: 4,
    lg: 6
  }, /*#__PURE__*/React.createElement(DemoContent, null, /*#__PURE__*/React.createElement("p", null, "Small: Span 2 of 4"), /*#__PURE__*/React.createElement("p", null, "Medium: Span 4 of 8"), /*#__PURE__*/React.createElement("p", null, "Large: Span 6 of 12"))), /*#__PURE__*/React.createElement(Column, {
    sm: 2,
    md: 2,
    lg: 3
  }, /*#__PURE__*/React.createElement(DemoContent, null, /*#__PURE__*/React.createElement("p", null, "Small: Span 2 of 4"), /*#__PURE__*/React.createElement("p", null, "Medium: Span 2 of 8"), /*#__PURE__*/React.createElement("p", null, "Large: Span 3 of 12"))), /*#__PURE__*/React.createElement(Column, {
    sm: 0,
    md: 2,
    lg: 3
  }, /*#__PURE__*/React.createElement(DemoContent, null, /*#__PURE__*/React.createElement("p", null, "Small: Span 0 of 4"), /*#__PURE__*/React.createElement("p", null, "Medium: Span 2 of 8"), /*#__PURE__*/React.createElement("p", null, "Large: Span 3 of 12")))));
};
export var offset = function offset() {
  return /*#__PURE__*/React.createElement(Grid, null, /*#__PURE__*/React.createElement(Row, null, /*#__PURE__*/React.createElement(Column, {
    sm: {
      span: 1,
      offset: 3
    }
  }, /*#__PURE__*/React.createElement(DemoContent, null, "Small: offset 3")), /*#__PURE__*/React.createElement(Column, {
    sm: {
      span: 2,
      offset: 2
    }
  }, /*#__PURE__*/React.createElement(DemoContent, null, "Small: offset 2")), /*#__PURE__*/React.createElement(Column, {
    sm: {
      span: 3,
      offset: 1
    }
  }, /*#__PURE__*/React.createElement(DemoContent, null, "Small: offset 1")), /*#__PURE__*/React.createElement(Column, {
    sm: {
      span: 4,
      offset: 0
    }
  }, /*#__PURE__*/React.createElement(DemoContent, null, "Small: offset 0"))));
};
export var condensed = function condensed() {
  return /*#__PURE__*/React.createElement(Grid, {
    condensed: true
  }, /*#__PURE__*/React.createElement(Row, null, /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4"))));
};
export var condensedColumns = function condensedColumns() {
  return /*#__PURE__*/React.createElement(Grid, null, /*#__PURE__*/React.createElement(Row, null, /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4"))), /*#__PURE__*/React.createElement(Row, {
    condensed: true
  }, /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4"))), /*#__PURE__*/React.createElement(Row, null, /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4"))));
};
export var narrow = function narrow() {
  return /*#__PURE__*/React.createElement(Grid, {
    narrow: true
  }, /*#__PURE__*/React.createElement(Row, null, /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4"))));
};
export var narrowColumns = function narrowColumns() {
  return /*#__PURE__*/React.createElement(Grid, null, /*#__PURE__*/React.createElement(Row, null, /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4"))), /*#__PURE__*/React.createElement(Row, {
    narrow: true
  }, /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4"))), /*#__PURE__*/React.createElement(Row, null, /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4"))));
};
export var fullWidth = function fullWidth() {
  return /*#__PURE__*/React.createElement(Grid, {
    fullWidth: true
  }, /*#__PURE__*/React.createElement(Row, null, /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4"))));
};
export var mixedGridModes = function mixedGridModes() {
  return /*#__PURE__*/React.createElement(Grid, null, /*#__PURE__*/React.createElement(Row, null, /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "Wide")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4"))), /*#__PURE__*/React.createElement(Row, {
    narrow: true
  }, /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "Narrow")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4"))), /*#__PURE__*/React.createElement(Row, {
    condensed: true
  }, /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "Condensed")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4")), /*#__PURE__*/React.createElement(Column, null, /*#__PURE__*/React.createElement(DemoContent, null, "1/4"))));
};