import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "children", "id"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import PropTypes from 'prop-types';
import React from 'react';
import classnames from 'classnames';
import { usePrefix } from '../../internal/usePrefix';
import * as FeatureFlags from '@carbon/feature-flags';

var FormLabel = function FormLabel(_ref) {
  var _classnames;

  var className = _ref.className,
      children = _ref.children,
      id = _ref.id,
      other = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();
  var classNames = classnames((_classnames = {}, _defineProperty(_classnames, "".concat(prefix, "--label"), !FeatureFlags.enabled('enable-v11-release')), _defineProperty(_classnames, "".concat(prefix, "--label--no-margin"), FeatureFlags.enabled('enable-v11-release')), _classnames), className);
  return /*#__PURE__*/React.createElement("label", _extends({
    htmlFor: id,
    className: classNames
  }, other), children);
};

FormLabel.propTypes = {
  /**
   * Specify the content of the form label
   */
  children: PropTypes.node,

  /**
   * Provide a custom className to be applied to the containing <label> node
   */
  className: PropTypes.string,

  /**
   * Provide a unique id for the given <FormLabel>
   */
  id: PropTypes.string
};
export default FormLabel;