/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { useEffect, useRef } from 'react';
import { focus } from '../../internal/focus';
export function useAutoFocus(getElementOrRef) {
  var callbackRef = useRef(getElementOrRef);
  useEffect(function () {
    if (callbackRef.current) {
      var elementOrRef = callbackRef.current();
      var element = elementOrRef.current || elementOrRef;

      if (element) {
        focus(element);
      }
    }
  }, []);
}