import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
import _extends from "@babel/runtime/helpers/extends";
import _toConsumableArray from "@babel/runtime/helpers/toConsumableArray";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
var _excluded = ["uuid", "name", "filesize", "status", "iconDescription", "invalid"];
import _regeneratorRuntime from "@babel/runtime/regenerator";

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) { symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); } keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState, useCallback, useEffect } from 'react';
import classnames from 'classnames';
import { settings } from 'carbon-components';
import FileUploaderItem from '../FileUploaderItem';
import FileUploaderDropContainer from '../FileUploaderDropContainer';
import FormItem from '../../FormItem';
import uid from '../../../tools/uniqueId';
import '../FileUploader-story.scss';
var prefix = settings.prefix;

var ExampleDropContainerApp = function ExampleDropContainerApp(props) {
  var _useState = useState([]),
      _useState2 = _slicedToArray(_useState, 2),
      files = _useState2[0],
      setFiles = _useState2[1];

  var handleDrop = function handleDrop(e) {
    e.preventDefault();
  };

  var handleDragover = function handleDragover(e) {
    e.preventDefault();
  };

  useEffect(function () {
    document.addEventListener('drop', handleDrop);
    document.addEventListener('dragover', handleDragover);
    return function () {
      document.removeEventListener('drop', handleDrop);
      document.removeEventListener('dragover', handleDragover);
    };
  }, []);

  var uploadFile = /*#__PURE__*/function () {
    var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(fileToUpload) {
      var updatedFile, _updatedFile, rand;

      return _regeneratorRuntime.wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              if (!(fileToUpload.filesize > 512000)) {
                _context.next = 4;
                break;
              }

              updatedFile = _objectSpread(_objectSpread({}, fileToUpload), {}, {
                status: 'edit',
                iconDescription: 'Delete file',
                invalid: true,
                errorSubject: 'File size exceeds limit',
                errorBody: '500kb max file size. Select a new file and try again.'
              });
              setFiles(function (files) {
                return files.map(function (file) {
                  return file.uuid === fileToUpload.uuid ? updatedFile : file;
                });
              });
              return _context.abrupt("return");

            case 4:
              if (!fileToUpload.invalidFileType) {
                _context.next = 8;
                break;
              }

              _updatedFile = _objectSpread(_objectSpread({}, fileToUpload), {}, {
                status: 'edit',
                iconDescription: 'Delete file',
                invalid: true,
                errorSubject: 'Invalid file type',
                errorBody: "\"".concat(fileToUpload.name, "\" does not have a valid file type.")
              });
              setFiles(function (files) {
                return files.map(function (file) {
                  return file.uuid === fileToUpload.uuid ? _updatedFile : file;
                });
              });
              return _context.abrupt("return");

            case 8:
              // simulate network request time
              rand = Math.random() * 1000;
              setTimeout(function () {
                var updatedFile = _objectSpread(_objectSpread({}, fileToUpload), {}, {
                  status: 'complete',
                  iconDescription: 'Upload complete'
                });

                setFiles(function (files) {
                  return files.map(function (file) {
                    return file.uuid === fileToUpload.uuid ? updatedFile : file;
                  });
                });
              }, rand); // show x icon after 1 second

              setTimeout(function () {
                var updatedFile = _objectSpread(_objectSpread({}, fileToUpload), {}, {
                  status: 'edit',
                  iconDescription: 'Delete file'
                });

                setFiles(function (files) {
                  return files.map(function (file) {
                    return file.uuid === fileToUpload.uuid ? updatedFile : file;
                  });
                });
              }, rand + 1000);

            case 11:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }));

    return function uploadFile(_x) {
      return _ref.apply(this, arguments);
    };
  }();

  var onAddFiles = useCallback(function (evt, _ref2) {
    var addedFiles = _ref2.addedFiles;
    evt.stopPropagation();
    var newFiles = addedFiles.map(function (file) {
      return {
        uuid: uid(),
        name: file.name,
        filesize: file.size,
        status: 'uploading',
        iconDescription: 'Uploading',
        invalidFileType: file.invalidFileType
      };
    }); // eslint-disable-next-line react/prop-types

    if (props.multiple) {
      setFiles([].concat(_toConsumableArray(files), _toConsumableArray(newFiles)));
      newFiles.forEach(uploadFile);
    } else if (newFiles[0]) {
      setFiles([newFiles[0]]);
      uploadFile(newFiles[0]);
    }
  }, // eslint-disable-next-line react/prop-types
  [files, props.multiple]);
  var handleFileUploaderItemClick = useCallback(function (_, _ref3) {
    var clickedUuid = _ref3.uuid;
    return setFiles(files.filter(function (_ref4) {
      var uuid = _ref4.uuid;
      return clickedUuid !== uuid;
    }));
  }, [files]);
  var labelClasses = classnames("".concat(prefix, "--file--label"), _defineProperty({}, "".concat(prefix, "--file--label--disabled"), props.disabled));
  var helperTextClasses = classnames("".concat(prefix, "--label-description"), _defineProperty({}, "".concat(prefix, "--label-description--disabled"), props.disabled));
  return /*#__PURE__*/React.createElement(FormItem, null, /*#__PURE__*/React.createElement("p", {
    className: labelClasses
  }, "Upload files"), /*#__PURE__*/React.createElement("p", {
    className: helperTextClasses
  }, "Max file size is 500kb. Supported file types are .jpg and .png."), /*#__PURE__*/React.createElement(FileUploaderDropContainer, _extends({}, props, {
    onAddFiles: onAddFiles
  })), /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--file-container"),
    style: {
      width: '100%'
    }
  }, files.map(function (_ref5) {
    var uuid = _ref5.uuid,
        name = _ref5.name,
        filesize = _ref5.filesize,
        status = _ref5.status,
        iconDescription = _ref5.iconDescription,
        invalid = _ref5.invalid,
        rest = _objectWithoutProperties(_ref5, _excluded);

    return /*#__PURE__*/React.createElement(FileUploaderItem, _extends({
      key: uid(),
      uuid: uuid,
      name: name,
      filesize: filesize // eslint-disable-next-line react/prop-types
      ,
      size: props.size,
      status: status,
      iconDescription: iconDescription,
      invalid: invalid,
      onDelete: handleFileUploaderItemClick
    }, rest));
  })));
};

export default ExampleDropContainerApp;