import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React, { useState } from 'react';
import { action } from '@storybook/addon-actions';
import { ErrorBoundary, ErrorBoundaryContext } from './';
import Button from '../Button';
export default {
  title: 'Components/ErrorBoundary',
  parameters: {
    component: ErrorBoundary
  }
};
export var Default = function Default() {
  function DemoComponent() {
    var _useState = useState(false),
        _useState2 = _slicedToArray(_useState, 2),
        shouldThrowError = _useState2[0],
        setShouldThrowError = _useState2[1];

    function onClick() {
      setShouldThrowError(!shouldThrowError);
    }

    return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(Button, {
      onClick: onClick
    }, "Toggle throwing error"), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(ErrorBoundary, {
      fallback: /*#__PURE__*/React.createElement(Fallback, null)
    }, /*#__PURE__*/React.createElement(ThrowError, {
      shouldThrowError: shouldThrowError
    }))));
  }

  function Fallback() {
    return 'Whoops';
  }

  function ThrowError(_ref) {
    var shouldThrowError = _ref.shouldThrowError;

    if (shouldThrowError) {
      throw new Error('Component threw error');
    }

    return 'Successfully rendered';
  }

  return /*#__PURE__*/React.createElement(DemoComponent, null);
};
Default.storyName = 'default';
export var WithCustomContext = function WithCustomContext() {
  function DemoComponent() {
    var _useState3 = useState(false),
        _useState4 = _slicedToArray(_useState3, 2),
        shouldThrowError = _useState4[0],
        setShouldThrowError = _useState4[1];

    function onClick() {
      setShouldThrowError(!shouldThrowError);
    }

    return /*#__PURE__*/React.createElement(ErrorBoundaryContext.Provider, {
      value: {
        log: action('log')
      }
    }, /*#__PURE__*/React.createElement(Button, {
      onClick: onClick
    }, "Toggle throwing error"), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(ErrorBoundary, {
      fallback: /*#__PURE__*/React.createElement(Fallback, null)
    }, /*#__PURE__*/React.createElement(ThrowError, {
      shouldThrowError: shouldThrowError
    }))));
  }

  function Fallback() {
    return 'Whoops';
  }

  function ThrowError(_ref2) {
    var shouldThrowError = _ref2.shouldThrowError;

    if (shouldThrowError) {
      throw new Error('Component threw error');
    }

    return 'Successfully rendered';
  }

  return /*#__PURE__*/React.createElement(DemoComponent, null);
};
WithCustomContext.storyName = 'with custom context';