import _extends from "@babel/runtime/helpers/extends";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import * as React from 'react';
import { FocusScope } from '../FocusScope';
import { Dialog } from '../Dialog';
import { useId } from '../../internal/useId';
import { Portal } from '../Portal';
export default {
  title: 'Experimental/unstable_Dialog',
  includeStories: []
};
export var Default = function Default() {
  function DemoComponent() {
    var _React$useState = React.useState(false),
        _React$useState2 = _slicedToArray(_React$useState, 2),
        open = _React$useState2[0],
        setOpen = _React$useState2[1];

    var ref = React.useRef(null);
    return /*#__PURE__*/React.createElement("div", {
      style: {
        border: '1px solid black',
        background: 'rgba(0, 0, 0, 0.1)',
        padding: '1rem'
      }
    }, /*#__PURE__*/React.createElement("button", {
      type: "button",
      onClick: function onClick() {
        setOpen(true);
      }
    }, "Open"), open ? /*#__PURE__*/React.createElement(FocusScope, null, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("p", null, "Elit hic at labore culpa itaque fugiat. Consequuntur iure autem autem officiis dolores facilis nulla earum! Neque quia nemo sequi assumenda ratione officia Voluptate beatae eligendi placeat nemo laborum, ratione."), /*#__PURE__*/React.createElement(DemoComponent, null), /*#__PURE__*/React.createElement("button", {
      ref: ref,
      type: "button",
      onClick: function onClick() {
        setOpen(false);
      }
    }, "Close"))) : null);
  }

  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(DemoComponent, null), /*#__PURE__*/React.createElement("button", {
    type: "button"
  }, "Hello"));
};
export var DialogExample = function DialogExample() {
  function Example() {
    var _React$useState3 = React.useState(false),
        _React$useState4 = _slicedToArray(_React$useState3, 2),
        open = _React$useState4[0],
        setOpen = _React$useState4[1];

    var id = useId();
    return /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("button", {
      type: "button"
    }, "First")), /*#__PURE__*/React.createElement("button", {
      type: "button",
      onClick: function onClick() {
        setOpen(true);
      }
    }, "Open"), open ? /*#__PURE__*/React.createElement(Portal, {
      style: {
        position: 'fixed',
        top: 0,
        right: 0,
        bottom: 0,
        left: 0,
        zIndex: 9999
      }
    }, /*#__PURE__*/React.createElement(FullPage, null), /*#__PURE__*/React.createElement(Dialog, {
      "aria-labelledby": id,
      onDismiss: function onDismiss() {
        setOpen(false);
      },
      style: {
        position: 'relative',
        zIndex: 9999,
        padding: '1rem',
        background: 'white'
      }
    }, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("span", {
      id: id
    }, "Hello")), /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement(Example, null)), /*#__PURE__*/React.createElement("button", {
      type: "button",
      onClick: function onClick() {
        setOpen(false);
      }
    }, "Close"))) : null, /*#__PURE__*/React.createElement("div", null, /*#__PURE__*/React.createElement("button", {
      type: "button"
    }, "Last")));
  }

  return /*#__PURE__*/React.createElement(Example, null);
};
var FullPage = /*#__PURE__*/React.forwardRef(function FullPage(props, ref) {
  return /*#__PURE__*/React.createElement("div", _extends({
    ref: ref,
    style: {
      position: 'absolute',
      top: 0,
      left: 0,
      bottom: 0,
      right: 0,
      transform: 'translateZ(0)',
      background: 'rgba(0, 0, 0, 0.5)'
    }
  }, props));
});