import _extends from "@babel/runtime/helpers/extends";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { default as DatePicker, DatePickerSkeleton } from '../';
import DatePickerInput from '../../DatePickerInput';
import { Layer } from '../../Layer'; // const patterns = {
//   'Short (d{1,2}/d{4})': '\\d{1,2}/\\d{4}',
//   'Regular (d{1,2}/d{1,2}/d{4})': '\\d{1,2}/\\d{1,2}/\\d{4}',
// };
// const sizes = {
//   'Small  (sm)': 'sm',
//   'Medium (md) - default': undefined,
//   'Large  (lg)': 'lg',
// };
// const types = {
//   Simple: 'simple',
//   Single: 'single',
//   Range: 'range',
// };

var props = {
  datePicker: function datePicker() {
    return {
      dateFormat: 'm/d/Y',
      id: 'date-picker',
      light: false,
      datePickerType: 'single',
      minDate: '11/15/2020',
      maxDate: '11/01/2040',
      disable: ['07/15/2021'],
      onClose: action('onClose'),
      onOpen: action('onOpen')
    };
  },
  datePickerInput: function datePickerInput() {
    return {
      id: 'date-picker-input-id',
      className: 'some-class',
      size: undefined,
      labelText: 'Date Picker label',
      pattern: 'd{1,2}/d{4}',
      placeholder: 'mm/dd/yyyy',
      disabled: false,
      invalid: false,
      invalidText: 'A valid date is required',
      warn: false,
      warnText: 'Selected dates may cause conflicts',
      iconDescription: 'Icon description'
    };
  }
};
export default {
  title: 'Components/DatePicker',
  parameters: {
    component: DatePicker,
    subcomponents: {
      DatePickerInput: DatePickerInput,
      DatePickerSkeleton: DatePickerSkeleton
    }
  }
};
export var Simple = function Simple() {
  return /*#__PURE__*/React.createElement(DatePicker, {
    datePickerType: "simple"
  }, /*#__PURE__*/React.createElement(DatePickerInput, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-simple"
  }));
};
export var SingleWithCalendar = function SingleWithCalendar() {
  return /*#__PURE__*/React.createElement(DatePicker, {
    datePickerType: "single"
  }, /*#__PURE__*/React.createElement(DatePickerInput, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-single"
  }));
};
export var RangeWithCalendar = function RangeWithCalendar() {
  return /*#__PURE__*/React.createElement(DatePicker, {
    datePickerType: "range"
  }, /*#__PURE__*/React.createElement(DatePickerInput, {
    id: "date-picker-input-id-start",
    placeholder: "mm/dd/yyyy",
    labelText: "Start date"
  }), /*#__PURE__*/React.createElement(DatePickerInput, {
    id: "date-picker-input-id-finish",
    placeholder: "mm/dd/yyyy",
    labelText: "End date"
  }));
};
export var SimpleWithLayer = function SimpleWithLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(DatePicker, {
    datePickerType: "simple"
  }, /*#__PURE__*/React.createElement(DatePickerInput, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-simple"
  })), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(DatePicker, {
    datePickerType: "simple"
  }, /*#__PURE__*/React.createElement(DatePickerInput, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-simple"
  })), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(DatePicker, {
    datePickerType: "simple"
  }, /*#__PURE__*/React.createElement(DatePickerInput, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-simple"
  })))));
};
export var SingleWithCalendarWithLayer = function SingleWithCalendarWithLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(DatePicker, {
    datePickerType: "single"
  }, /*#__PURE__*/React.createElement(DatePickerInput, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-single"
  })), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(DatePicker, {
    datePickerType: "single"
  }, /*#__PURE__*/React.createElement(DatePickerInput, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-single"
  })), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(DatePicker, {
    datePickerType: "single"
  }, /*#__PURE__*/React.createElement(DatePickerInput, {
    placeholder: "mm/dd/yyyy",
    labelText: "Date Picker label",
    id: "date-picker-single"
  })))));
};
export var RangeWithCalendarWithLayer = function RangeWithCalendarWithLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(DatePicker, {
    datePickerType: "range"
  }, /*#__PURE__*/React.createElement(DatePickerInput, {
    id: "date-picker-input-id-start",
    placeholder: "mm/dd/yyyy",
    labelText: "Start date"
  }), /*#__PURE__*/React.createElement(DatePickerInput, {
    id: "date-picker-input-id-finish",
    placeholder: "mm/dd/yyyy",
    labelText: "End date"
  })), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(DatePicker, {
    datePickerType: "range"
  }, /*#__PURE__*/React.createElement(DatePickerInput, {
    id: "date-picker-input-id-start",
    placeholder: "mm/dd/yyyy",
    labelText: "Start date"
  }), /*#__PURE__*/React.createElement(DatePickerInput, {
    id: "date-picker-input-id-finish",
    placeholder: "mm/dd/yyyy",
    labelText: "End date"
  })), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(DatePicker, {
    datePickerType: "range"
  }, /*#__PURE__*/React.createElement(DatePickerInput, {
    id: "date-picker-input-id-start",
    placeholder: "mm/dd/yyyy",
    labelText: "Start date"
  }), /*#__PURE__*/React.createElement(DatePickerInput, {
    id: "date-picker-input-id-finish",
    placeholder: "mm/dd/yyyy",
    labelText: "End date"
  })))));
};
/* eslint-disable react/prop-types */

export var DatePickerPlayground = function DatePickerPlayground() {
  return /*#__PURE__*/React.createElement(DatePicker, props.datePicker(), /*#__PURE__*/React.createElement(DatePickerInput, props.datePickerInput()), props.datePicker().datePickerType === 'range' && /*#__PURE__*/React.createElement(DatePickerInput, _extends({}, props.datePickerInput(), {
    id: "date-picker-input-2"
  })));
};
/* eslint-enable react/prop-types */

export var Skeleton = function Skeleton() {
  return /*#__PURE__*/React.createElement(DatePickerSkeleton, {
    range: true
  });
};