import _extends from "@babel/runtime/helpers/extends";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import { action } from '@storybook/addon-actions';
import React from 'react';
import Button from '../../Button';
import DataTable, { Table, TableBody, TableCell, TableContainer, TableHead, TableHeader, TableRow, TableToolbar, TableToolbarContent, TableToolbarSearch, TableToolbarMenu, TableToolbarAction } from '../../DataTable';
import { rows, headers } from './shared';
import mdx from '../DataTable.mdx';
export default {
  title: 'Components/DataTable/Filtering',
  component: DataTable,
  subcomponents: {
    TableToolbar: TableToolbar,
    TableToolbarContent: TableToolbarContent,
    TableToolbarSearch: TableToolbarSearch,
    TableToolbarMenu: TableToolbarMenu,
    TableToolbarAction: TableToolbarAction,
    Table: Table,
    TableBody: TableBody,
    TableCell: TableCell,
    TableContainer: TableContainer,
    TableHead: TableHead,
    TableHeader: TableHeader,
    TableRow: TableRow
  },
  parameters: {
    docs: {
      page: mdx
    }
  }
};
export var Usage = function Usage() {
  return /*#__PURE__*/React.createElement(DataTable, {
    rows: rows,
    headers: headers
  }, function (_ref) {
    var rows = _ref.rows,
        headers = _ref.headers,
        getHeaderProps = _ref.getHeaderProps,
        getRowProps = _ref.getRowProps,
        getTableProps = _ref.getTableProps,
        onInputChange = _ref.onInputChange;
    return /*#__PURE__*/React.createElement(TableContainer, {
      title: "DataTable",
      description: "With filtering"
    }, /*#__PURE__*/React.createElement(TableToolbar, null, /*#__PURE__*/React.createElement(TableToolbarContent, null, /*#__PURE__*/React.createElement(TableToolbarSearch, {
      onChange: onInputChange
    }), /*#__PURE__*/React.createElement(TableToolbarMenu, null, /*#__PURE__*/React.createElement(TableToolbarAction, {
      onClick: action('Action 1 Click')
    }, "Action 1"), /*#__PURE__*/React.createElement(TableToolbarAction, {
      onClick: action('Action 2 Click')
    }, "Action 2"), /*#__PURE__*/React.createElement(TableToolbarAction, {
      onClick: action('Action 3 Click')
    }, "Action 3")), /*#__PURE__*/React.createElement(Button, {
      onClick: action('Button click')
    }, "Primary Button"))), /*#__PURE__*/React.createElement(Table, getTableProps(), /*#__PURE__*/React.createElement(TableHead, null, /*#__PURE__*/React.createElement(TableRow, null, headers.map(function (header) {
      return /*#__PURE__*/React.createElement(TableHeader, _extends({
        key: header.key
      }, getHeaderProps({
        header: header
      })), header.header);
    }))), /*#__PURE__*/React.createElement(TableBody, null, rows.map(function (row) {
      return /*#__PURE__*/React.createElement(TableRow, _extends({
        key: row.id
      }, getRowProps({
        row: row
      })), row.cells.map(function (cell) {
        return /*#__PURE__*/React.createElement(TableCell, {
          key: cell.id
        }, cell.value);
      }));
    }))));
  });
};