import _extends from "@babel/runtime/helpers/extends";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "renderIcon", "iconDescription", "children"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import { settings } from 'carbon-components';
import OverflowMenu from '../OverflowMenu';
import { Settings16 } from '@carbon/icons-react';
var prefix = settings.prefix;

var TableToolbarMenu = function TableToolbarMenu(_ref) {
  var className = _ref.className,
      renderIcon = _ref.renderIcon,
      iconDescription = _ref.iconDescription,
      children = _ref.children,
      rest = _objectWithoutProperties(_ref, _excluded);

  var toolbarActionClasses = cx(className, "".concat(prefix, "--toolbar-action ").concat(prefix, "--overflow-menu"));
  return /*#__PURE__*/React.createElement(OverflowMenu, _extends({
    ariaLabel: iconDescription,
    renderIcon: renderIcon,
    className: toolbarActionClasses,
    title: iconDescription,
    iconDescription: iconDescription,
    flipped: true
  }, rest), children);
};

TableToolbarMenu.defaultProps = {
  renderIcon: Settings16,
  iconDescription: 'Settings'
};
TableToolbarMenu.propTypes = {
  children: PropTypes.node.isRequired,

  /**
   * Provide an optional class name for the toolbar menu
   */
  className: PropTypes.string,

  /**
   * The description of the menu icon.
   */
  iconDescription: PropTypes.string.isRequired,

  /**
   * Optional prop to allow overriding the default menu icon
   */
  renderIcon: PropTypes.oneOfType([PropTypes.func, PropTypes.object])
};
export default TableToolbarMenu;