import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "children", "title", "description", "stickyHeader", "useStaticWidth"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import { settings } from 'carbon-components';
var prefix = settings.prefix;

var TableContainer = function TableContainer(_ref) {
  var _cx;

  var className = _ref.className,
      children = _ref.children,
      title = _ref.title,
      description = _ref.description,
      stickyHeader = _ref.stickyHeader,
      useStaticWidth = _ref.useStaticWidth,
      rest = _objectWithoutProperties(_ref, _excluded);

  var tableContainerClasses = cx(className, "".concat(prefix, "--data-table-container"), (_cx = {}, _defineProperty(_cx, "".concat(prefix, "--data-table--max-width"), stickyHeader), _defineProperty(_cx, "".concat(prefix, "--data-table-container--static"), useStaticWidth), _cx));
  return /*#__PURE__*/React.createElement("div", _extends({}, rest, {
    className: tableContainerClasses
  }), title && /*#__PURE__*/React.createElement("div", {
    className: "".concat(prefix, "--data-table-header")
  }, /*#__PURE__*/React.createElement("h4", {
    className: "".concat(prefix, "--data-table-header__title")
  }, title), /*#__PURE__*/React.createElement("p", {
    className: "".concat(prefix, "--data-table-header__description")
  }, description)), children);
};

TableContainer.propTypes = {
  children: PropTypes.node,
  className: PropTypes.string,

  /**
   * Optional description text for the Table
   */
  description: PropTypes.node,

  /**
   * Specify whether the table should have a sticky header
   */
  stickyHeader: PropTypes.bool,

  /**
   * Provide a title for the Table
   */
  title: PropTypes.node,

  /**
   * If true, will use a width of 'fit-content' to match the inner table width
   */
  useStaticWidth: PropTypes.bool
};
export default TableContainer;