import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/slicedToArray";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["className", "children", "shouldShowBatchActions", "totalSelected", "onCancel", "translateWithId"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import cx from 'classnames';
import PropTypes from 'prop-types';
import React from 'react';
import { settings } from 'carbon-components';
import Button from '../Button';
import TableActionList from './TableActionList';
import { Text } from '../Text';
var prefix = settings.prefix;
var translationKeys = {
  'carbon.table.batch.cancel': 'Cancel',
  'carbon.table.batch.items.selected': 'items selected',
  'carbon.table.batch.item.selected': 'item selected'
};

var translateWithId = function translateWithId(id, state) {
  if (id === 'carbon.table.batch.cancel') {
    return translationKeys[id];
  }

  return "".concat(state.totalSelected, " ").concat(translationKeys[id]);
};

var TableBatchActions = function TableBatchActions(_ref) {
  var _cx;

  var className = _ref.className,
      children = _ref.children,
      shouldShowBatchActions = _ref.shouldShowBatchActions,
      totalSelected = _ref.totalSelected,
      onCancel = _ref.onCancel,
      t = _ref.translateWithId,
      rest = _objectWithoutProperties(_ref, _excluded);

  var _React$useState = React.useState(),
      _React$useState2 = _slicedToArray(_React$useState, 2),
      isScrolling = _React$useState2[0],
      setIsScrolling = _React$useState2[1];

  var batchActionsClasses = cx((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--batch-actions"), true), _defineProperty(_cx, "".concat(prefix, "--batch-actions--active"), shouldShowBatchActions), _cx), className);
  var batchSummaryClasses = cx("".concat(prefix, "--batch-summary"), _defineProperty({}, "".concat(prefix, "--batch-summary__scroll"), isScrolling));
  return /*#__PURE__*/React.createElement("div", _extends({
    onScroll: function onScroll() {
      setIsScrolling(!isScrolling);
    },
    "aria-hidden": !shouldShowBatchActions,
    className: batchActionsClasses
  }, rest), /*#__PURE__*/React.createElement("div", {
    className: batchSummaryClasses
  }, /*#__PURE__*/React.createElement("p", {
    className: "".concat(prefix, "--batch-summary__para")
  }, /*#__PURE__*/React.createElement(Text, {
    as: "span"
  }, totalSelected > 1 || totalSelected === 0 ? t('carbon.table.batch.items.selected', {
    totalSelected: totalSelected
  }) : t('carbon.table.batch.item.selected', {
    totalSelected: totalSelected
  })))), /*#__PURE__*/React.createElement(TableActionList, null, children, /*#__PURE__*/React.createElement(Button, {
    className: "".concat(prefix, "--batch-summary__cancel"),
    tabIndex: shouldShowBatchActions ? 0 : -1,
    onClick: onCancel
  }, t('carbon.table.batch.cancel'))));
};

TableBatchActions.translationKeys = Object.keys(translationKeys);
TableBatchActions.propTypes = {
  children: PropTypes.node,
  className: PropTypes.string,

  /**
   * Hook required to listen for when the user initiates a cancel request
   * through this component
   */
  onCancel: PropTypes.func.isRequired,

  /**
   * Boolean specifier for whether or not the batch action bar should be
   * displayed
   */
  shouldShowBatchActions: PropTypes.bool,

  /**
   * Numeric representation of the total number of items selected in a table.
   * This number is used to derive the selection message
   */
  totalSelected: PropTypes.number.isRequired,

  /**
   * Supply a method to translate internal strings with your i18n tool of
   * choice. Translation keys are available on the `translationKeys` field for
   * this component.
   */
  translateWithId: PropTypes.func
};
TableBatchActions.defaultProps = {
  translateWithId: translateWithId
};
export default TableBatchActions;