/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import ContentSwitcher from '../';
import Switch from '../../Switch';
import { Layer } from '../../Layer';
export default {
  title: 'Components/ContentSwitcher',
  parameters: {
    component: ContentSwitcher,
    subcomponents: {
      Switch: Switch
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(ContentSwitcher, {
    onChange: function onChange() {}
  }, /*#__PURE__*/React.createElement(Switch, {
    name: "one",
    text: "First section"
  }), /*#__PURE__*/React.createElement(Switch, {
    name: "two",
    text: "Second section"
  }), /*#__PURE__*/React.createElement(Switch, {
    name: "three",
    text: "Third section"
  }));
};
export var withLayer = function withLayer() {
  return /*#__PURE__*/React.createElement(React.Fragment, null, /*#__PURE__*/React.createElement(ContentSwitcher, {
    onChange: function onChange() {}
  }, /*#__PURE__*/React.createElement(Switch, {
    name: "one",
    text: "First section"
  }), /*#__PURE__*/React.createElement(Switch, {
    name: "two",
    text: "Second section"
  }), /*#__PURE__*/React.createElement(Switch, {
    name: "three",
    text: "Third section"
  })), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(ContentSwitcher, {
    onChange: function onChange() {}
  }, /*#__PURE__*/React.createElement(Switch, {
    name: "one",
    text: "First section"
  }), /*#__PURE__*/React.createElement(Switch, {
    name: "two",
    text: "Second section"
  }), /*#__PURE__*/React.createElement(Switch, {
    name: "three",
    text: "Third section"
  })), /*#__PURE__*/React.createElement(Layer, null, /*#__PURE__*/React.createElement(ContentSwitcher, {
    onChange: function onChange() {}
  }, /*#__PURE__*/React.createElement(Switch, {
    name: "one",
    text: "First section"
  }), /*#__PURE__*/React.createElement(Switch, {
    name: "two",
    text: "Second section"
  }), /*#__PURE__*/React.createElement(Switch, {
    name: "three",
    text: "Third section"
  })))));
};