import _extends from "@babel/runtime/helpers/extends";

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { action } from '@storybook/addon-actions';
import { withKnobs, boolean, select } from '@storybook/addon-knobs';
import ContentSwitcher from '../ContentSwitcher';
import Switch from '../Switch';
import mdx from './ContentSwitcher.mdx';
var selectionModes = {
  'Change selection automatically upon focus (automatic)': 'automatic',
  'Change selection on explicit gesture (manual)': 'manual'
};
var sizes = {
  'Small  (sm)': 'sm',
  'Medium (md) - default': undefined,
  'Large  (lg)': 'lg'
};
var props = {
  contentSwitcher: function contentSwitcher() {
    return {
      light: boolean('[Deprecated]: Light variant (light)', false),
      selectedIndex: select('Selected index (selectedIndex)', [0, 1, 2], 0),
      selectionMode: select('Selection mode (selectionMode)', selectionModes, 'automatic'),
      size: select('Field size (size)', sizes, undefined) || undefined,
      onChange: action('onChange')
    };
  },
  switch: function _switch() {
    return {
      onClick: action('onClick - Switch'),
      disabled: boolean('Disabled (disabled)', false)
    };
  }
};
export default {
  title: 'Components/ContentSwitcher',
  decorators: [withKnobs],
  parameters: {
    component: ContentSwitcher,
    subcomponents: {
      Switch: Switch
    },
    docs: {
      page: mdx
    }
  }
};
export var Default = function Default() {
  return /*#__PURE__*/React.createElement(ContentSwitcher, {
    onChange: function onChange() {}
  }, /*#__PURE__*/React.createElement(Switch, {
    name: "one",
    text: "First section"
  }), /*#__PURE__*/React.createElement(Switch, {
    name: "two",
    text: "Second section"
  }), /*#__PURE__*/React.createElement(Switch, {
    name: "three",
    text: "Third section"
  }));
};
Default.story = {
  name: 'Content Switcher'
};
export var ContentSwitcherPlayground = function ContentSwitcherPlayground() {
  var switchProps = props.switch();
  return /*#__PURE__*/React.createElement(ContentSwitcher, props.contentSwitcher(), /*#__PURE__*/React.createElement(Switch, _extends({
    name: "one",
    text: "First section"
  }, switchProps)), /*#__PURE__*/React.createElement(Switch, _extends({
    name: "two",
    text: "Second section"
  }, switchProps)), /*#__PURE__*/React.createElement(Switch, _extends({
    name: "three",
    text: "Third section"
  }, switchProps)));
};