import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["buttonOnClick", "children", "className", "closeClassName", "closeIconClassName", "closeModal", "iconDescription", "label", "labelClassName", "title", "titleClassName"];

/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import PropTypes from 'prop-types';
import cx from 'classnames';
import { Close20 } from '@carbon/icons-react';
import { usePrefix } from '../../../internal/usePrefix';
export function ModalHeader(_ref) {
  var _cx, _cx2, _cx3, _cx4, _cx5;

  var buttonOnClick = _ref.buttonOnClick,
      children = _ref.children,
      customClassName = _ref.className,
      closeClassName = _ref.closeClassName,
      closeIconClassName = _ref.closeIconClassName,
      closeModal = _ref.closeModal,
      iconDescription = _ref.iconDescription,
      label = _ref.label,
      labelClassName = _ref.labelClassName,
      title = _ref.title,
      titleClassName = _ref.titleClassName,
      rest = _objectWithoutProperties(_ref, _excluded);

  var prefix = usePrefix();

  function handleCloseButtonClick(evt) {
    closeModal(evt);
    buttonOnClick();
  }

  var headerClass = cx((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--modal-header"), true), _defineProperty(_cx, customClassName, customClassName), _cx));
  var labelClass = cx((_cx2 = {}, _defineProperty(_cx2, "".concat(prefix, "--modal-header__label ").concat(prefix, "--type-delta"), true), _defineProperty(_cx2, labelClassName, labelClassName), _cx2));
  var titleClass = cx((_cx3 = {}, _defineProperty(_cx3, "".concat(prefix, "--modal-header__heading ").concat(prefix, "--type-beta"), true), _defineProperty(_cx3, titleClassName, titleClassName), _cx3));
  var closeClass = cx((_cx4 = {}, _defineProperty(_cx4, "".concat(prefix, "--modal-close"), true), _defineProperty(_cx4, closeClassName, closeClassName), _cx4));
  var closeIconClass = cx((_cx5 = {}, _defineProperty(_cx5, "".concat(prefix, "--modal-close__icon"), true), _defineProperty(_cx5, closeIconClassName, closeIconClassName), _cx5));
  return /*#__PURE__*/React.createElement("div", _extends({
    className: headerClass
  }, rest), label && /*#__PURE__*/React.createElement("h2", {
    className: labelClass
  }, label), title && /*#__PURE__*/React.createElement("h3", {
    className: titleClass
  }, title), children, /*#__PURE__*/React.createElement("button", {
    onClick: handleCloseButtonClick,
    className: closeClass,
    title: iconDescription,
    "aria-label": iconDescription,
    type: "button"
  }, /*#__PURE__*/React.createElement(Close20, {
    className: closeIconClass
  })));
}
ModalHeader.propTypes = {
  /**
   * Provide an optional function to be called when the close button is
   * clicked
   */
  buttonOnClick: PropTypes.func,

  /**
   * Specify the content to be placed in the ModalHeader
   */
  children: PropTypes.node,

  /**
   * Specify an optional className to be applied to the modal header
   */
  className: PropTypes.string,

  /**
   * Specify an optional className to be applied to the modal close node
   */
  closeClassName: PropTypes.string,

  /**
   * Specify an optional className to be applied to the modal close icon node
   */
  closeIconClassName: PropTypes.string,

  /**
   * Provide an optional function to be called when the modal is closed
   */
  closeModal: PropTypes.func,

  /**
   * Specify a description for the close icon that can be read by screen
   * readers
   */
  iconDescription: PropTypes.string,

  /**
   * Specify an optional label to be displayed
   */
  label: PropTypes.node,

  /**
   * Specify an optional className to be applied to the modal header label
   */
  labelClassName: PropTypes.string,

  /**
   * Specify an optional title to be displayed
   */
  title: PropTypes.node,

  /**
   * Specify an optional className to be applied to the modal heading
   */
  titleClassName: PropTypes.string
};
ModalHeader.defaultProps = {
  iconDescription: 'Close',
  buttonOnClick: function buttonOnClick() {},
  closeModal: function closeModal() {}
};