import _extends from "@babel/runtime/helpers/extends";
import _defineProperty from "@babel/runtime/helpers/defineProperty";
import _objectWithoutProperties from "@babel/runtime/helpers/objectWithoutProperties";
var _excluded = ["children", "className", "closeModal", "danger", "inputref", "onRequestClose", "onRequestSubmit", "primaryButtonDisabled", "primaryButtonText", "primaryClassName", "secondaryButtonText", "secondaryButtons", "secondaryClassName"];
import React from 'react';
import PropTypes from 'prop-types';
import Button from '../../Button';
import ButtonSet from '../../ButtonSet';
import cx from 'classnames';
import { usePrefix } from '../../../internal/usePrefix';

function SecondaryButtonSet(_ref) {
  var secondaryButtons = _ref.secondaryButtons,
      secondaryButtonText = _ref.secondaryButtonText,
      secondaryClassName = _ref.secondaryClassName,
      closeModal = _ref.closeModal,
      onRequestClose = _ref.onRequestClose;

  function handleRequestClose(evt) {
    closeModal(evt);
    onRequestClose(evt);
  }

  if (Array.isArray(secondaryButtons) && secondaryButtons.length <= 2) {
    return secondaryButtons.map(function (_ref2, i) {
      var buttonText = _ref2.buttonText,
          onButtonClick = _ref2.onClick;
      return /*#__PURE__*/React.createElement(Button, {
        key: "".concat(buttonText, "-").concat(i),
        className: secondaryClassName,
        kind: "secondary",
        onClick: onButtonClick || handleRequestClose
      }, buttonText);
    });
  }

  if (secondaryButtonText) {
    return /*#__PURE__*/React.createElement(Button, {
      className: secondaryClassName,
      onClick: handleRequestClose,
      kind: "secondary"
    }, secondaryButtonText);
  }

  return null;
}

SecondaryButtonSet.propTypes = {
  closeModal: PropTypes.func,
  onRequestClose: PropTypes.func,
  secondaryButtonText: PropTypes.string,
  secondaryButtons: function secondaryButtons(props, propName, componentName) {
    if (props.secondaryButtons) {
      if (!Array.isArray(props.secondaryButtons) || props.secondaryButtons.length !== 2) {
        return new Error("".concat(propName, " needs to be an array of two button config objects"));
      }

      var shape = {
        buttonText: PropTypes.node,
        onClick: PropTypes.func
      };
      props[propName].forEach(function (secondaryButton) {
        PropTypes.checkPropTypes(shape, secondaryButton, propName, componentName);
      });
    }

    return null;
  },
  secondaryClassName: PropTypes.string
};
export function ModalFooter(_ref3) {
  var _cx;

  var children = _ref3.children,
      customClassName = _ref3.className,
      closeModal = _ref3.closeModal,
      danger = _ref3.danger,
      inputref = _ref3.inputref,
      onRequestClose = _ref3.onRequestClose,
      onRequestSubmit = _ref3.onRequestSubmit,
      primaryButtonDisabled = _ref3.primaryButtonDisabled,
      primaryButtonText = _ref3.primaryButtonText,
      primaryClassName = _ref3.primaryClassName,
      secondaryButtonText = _ref3.secondaryButtonText,
      secondaryButtons = _ref3.secondaryButtons,
      secondaryClassName = _ref3.secondaryClassName,
      rest = _objectWithoutProperties(_ref3, _excluded);

  var prefix = usePrefix();
  var footerClass = cx((_cx = {}, _defineProperty(_cx, "".concat(prefix, "--modal-footer"), true), _defineProperty(_cx, customClassName, customClassName), _defineProperty(_cx, "".concat(prefix, "--modal-footer--three-button"), Array.isArray(secondaryButtons) && secondaryButtons.length === 2), _cx));
  var secondaryButtonProps = {
    closeModal: closeModal,
    secondaryButtons: secondaryButtons,
    secondaryButtonText: secondaryButtonText,
    secondaryClassName: secondaryClassName,
    onRequestClose: onRequestClose
  };
  return /*#__PURE__*/React.createElement(ButtonSet, _extends({
    className: footerClass
  }, rest), /*#__PURE__*/React.createElement(SecondaryButtonSet, secondaryButtonProps), primaryButtonText && /*#__PURE__*/React.createElement(Button, {
    onClick: onRequestSubmit,
    className: primaryClassName,
    disabled: primaryButtonDisabled,
    kind: danger ? 'danger' : 'primary',
    ref: inputref
  }, primaryButtonText), children);
}
ModalFooter.propTypes = {
  /**
   * Pass in content that will be rendered in the Modal Footer
   */
  children: PropTypes.node,

  /**
   * Specify a custom className to be applied to the Modal Footer container
   */
  className: PropTypes.string,

  /**
   * Specify an optional function that is called whenever the modal is closed
   */
  closeModal: PropTypes.func,

  /**
   * Specify whether the primary button should be replaced with danger button.
   * Note that this prop is not applied if you render primary/danger button by yourself
   */
  danger: PropTypes.bool,

  /**
   * The `ref` callback for the primary button.
   */
  inputref: PropTypes.oneOfType([PropTypes.func, PropTypes.shape({
    current: PropTypes.any
  })]),

  /**
   * Specify an optional function for when the modal is requesting to be
   * closed
   */
  onRequestClose: PropTypes.func,

  /**
   * Specify an optional function for when the modal is requesting to be
   * submitted
   */
  onRequestSubmit: PropTypes.func,

  /**
   * Specify whether the primary button should be disabled
   */
  primaryButtonDisabled: PropTypes.bool,

  /**
   * Specify the text for the primary button
   */
  primaryButtonText: PropTypes.string,

  /**
   * Specify a custom className to be applied to the primary button
   */
  primaryClassName: PropTypes.string,

  /**
   * Specify the text for the secondary button
   */
  secondaryButtonText: PropTypes.string,

  /**
   * Specify an array of config objects for secondary buttons
   * (`Array<{
   *   buttonText: string,
   *   onClick: function,
   * }>`).
   */
  secondaryButtons: function secondaryButtons(props, propName, componentName) {
    if (props.secondaryButtons) {
      if (!Array.isArray(props.secondaryButtons) || props.secondaryButtons.length !== 2) {
        return new Error("".concat(propName, " needs to be an array of two button config objects"));
      }

      var shape = {
        buttonText: PropTypes.node,
        onClick: PropTypes.func
      };
      props[propName].forEach(function (secondaryButton) {
        PropTypes.checkPropTypes(shape, secondaryButton, propName, componentName);
      });
    }

    return null;
  },

  /**
   * Specify a custom className to be applied to the secondary button
   */
  secondaryClassName: PropTypes.string
};
ModalFooter.defaultProps = {
  onRequestClose: function onRequestClose() {},
  onRequestSubmit: function onRequestSubmit() {},
  closeModal: function closeModal() {}
};