/**
 * Copyright IBM Corp. 2016, 2018
 *
 * This source code is licensed under the Apache-2.0 license found in the
 * LICENSE file in the root directory of this source tree.
 */
import React from 'react';
import { mount } from 'enzyme';
import ComposedModal from './ComposedModal';
import { ModalHeader } from './ModalHeader';
import { ModalFooter } from '../ComposedModal';
import { settings } from 'carbon-components';
var prefix = settings.prefix;
describe('<ComposedModal />', function () {
  var container;
  afterEach(function () {
    if (container && container.parentNode) {
      container.parentNode.removeChild(container);
    }

    container = null;
  });
  it('renders', function () {
    var wrapper = mount( /*#__PURE__*/React.createElement(ComposedModal, {
      open: true
    }));
    expect(wrapper).toMatchSnapshot();
  });
  it('changes the open state upon change in props', function () {
    var wrapper = mount( /*#__PURE__*/React.createElement(ComposedModal, {
      open: true
    }));
    expect(document.body.classList.contains('bx--body--with-modal-open')).toEqual(true);
    wrapper.setProps({
      open: false
    });
    expect(document.body.classList.contains('bx--body--with-modal-open')).toEqual(false);
  });
  it('should change class of <body> upon open state', function () {
    var wrapper = mount( /*#__PURE__*/React.createElement(ComposedModal, {
      open: true
    }));
    expect(document.body.classList.contains('bx--body--with-modal-open')).toEqual(true);
    wrapper.unmount();
    expect(document.body.classList.contains('bx--body--with-modal-open')).toEqual(false);
    mount( /*#__PURE__*/React.createElement(ComposedModal, {
      open: false
    }));
    expect(document.body.classList.contains('bx--body--with-modal-open')).toEqual(false);
  });
  it('calls onClick upon user-initiated closing', function () {
    var onClose = jest.fn();
    var wrapper = mount( /*#__PURE__*/React.createElement(ComposedModal, {
      open: true,
      onClose: onClose
    }, /*#__PURE__*/React.createElement(ModalHeader, null)));
    var button = wrapper.find(".".concat(prefix, "--modal-close")).first();
    button.simulate('click');
    expect(document.body.classList.contains('bx--body--with-modal-open')).toEqual(false);
    expect(onClose.mock.calls.length).toBe(1);
  });
  it('provides a way to prevent upon user-initiated closing', function () {
    var onClose = jest.fn(function () {
      return false;
    });
    var wrapper = mount( /*#__PURE__*/React.createElement(ComposedModal, {
      open: true,
      onClose: onClose
    }, /*#__PURE__*/React.createElement(ModalHeader, null)));
    var button = wrapper.find(".".concat(prefix, "--modal-close")).first();
    button.simulate('click');
    expect(document.body.classList.contains('bx--body--with-modal-open')).toEqual(true);
  });
  it('should focus on the primary actionable button in ModalFooter by default', function () {
    container = document.createElement('div');
    container.id = 'container';
    document.body.appendChild(container);
    mount( /*#__PURE__*/React.createElement(ComposedModal, {
      open: true
    }, /*#__PURE__*/React.createElement(ModalFooter, {
      primaryButtonText: "Save"
    })), {
      attachTo: document.querySelector('#container')
    });
    expect(document.activeElement.classList.contains("".concat(prefix, "--btn--primary"))).toEqual(true);
  });
  it('should focus on the element that matches selectorPrimaryFocus', function () {
    container = document.createElement('div');
    container.id = 'container';
    document.body.appendChild(container);
    mount( /*#__PURE__*/React.createElement(ComposedModal, {
      open: true,
      selectorPrimaryFocus: ".".concat(prefix, "--modal-close")
    }, /*#__PURE__*/React.createElement(ModalHeader, {
      label: "Optional Label",
      title: "Example"
    }), /*#__PURE__*/React.createElement(ModalFooter, {
      primaryButtonText: "Save"
    })), {
      attachTo: document.querySelector('#container')
    });
    expect(document.activeElement.classList.contains("".concat(prefix, "--modal-close"))).toEqual(true);
  });
});